/*
 * Decompiled with CFR 0.152.
 */
package testing_maven;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class SFTP_Free_Edition
extends JFrame {
    private JButton connectButton;
    private JButton disconnectButton;
    private JLabel connectionStatusLabel;
    private JLabel developedByLabel;
    private JTextField hostField;
    private JTextField portField;
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JTextField localPathField;
    private JTextField remotePathField;
    private JTable localFileTable;
    private JTable remoteFileTable;
    private JProgressBar progressBar;
    private JTextArea logArea;
    private JLabel statusLabel;
    private DefaultTableModel localTableModel;
    private DefaultTableModel remoteTableModel;
    private Session session;
    private ChannelSftp sftpChannel;
    private String currentLocalPath = System.getProperty("user.home");
    private String currentRemotePath = "/";
    private boolean isConnected = false;
    private ImageIcon folderIcon;
    private ImageIcon fileIcon;
    private static final Color CONNECTED_COLOR = new Color(34, 139, 34);
    private static final Color DISCONNECTED_COLOR = new Color(178, 34, 34);
    private static final Color CONNECT_BUTTON_BG = new Color(70, 130, 180);
    private static final Color UPLOAD_BUTTON_BG = new Color(60, 179, 113);
    private static final Color DOWNLOAD_BUTTON_BG = new Color(70, 130, 180);
    private static final Color ACTION_BUTTON_BG = new Color(211, 211, 211);

    public SFTP_Free_Edition() {
        this.initComponents();
        this.customInit();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Secure SFTP Free Edition");
        this.setSize(new Dimension(1400, 900));
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        this.setContentPane(mainPanel);
        JPanel connectionPanel = new JPanel(new BorderLayout(5, 5));
        connectionPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel fieldsPanel = new JPanel(new FlowLayout(0, 10, 5));
        fieldsPanel.add(new JLabel("Host:"));
        this.hostField = new JTextField("localhost", 15);
        fieldsPanel.add(this.hostField);
        fieldsPanel.add(new JLabel("Port:"));
        this.portField = new JTextField("22", 5);
        fieldsPanel.add(this.portField);
        fieldsPanel.add(new JLabel("Username:"));
        this.usernameField = new JTextField(12);
        fieldsPanel.add(this.usernameField);
        fieldsPanel.add(new JLabel("Password:"));
        this.passwordField = new JPasswordField(12);
        fieldsPanel.add(this.passwordField);
        this.connectButton = new JButton("Connect");
        this.disconnectButton = new JButton("Disconnect");
        this.disconnectButton.setEnabled(false);
        fieldsPanel.add(this.connectButton);
        fieldsPanel.add(this.disconnectButton);
        this.connectionStatusLabel = new JLabel("\u25cf Not Connected");
        this.connectionStatusLabel.setForeground(DISCONNECTED_COLOR);
        this.connectionStatusLabel.setFont(new Font("Arial", 1, 12));
        fieldsPanel.add(this.connectionStatusLabel);
        connectionPanel.add((Component)fieldsPanel, "Center");
        JPanel infoPanel = new JPanel(new FlowLayout(2, 10, 5));
        this.developedByLabel = new JLabel("Developed by: Secure ARS PKY Enterprises ");
        this.developedByLabel.setFont(new Font("Arial", 3, 11));
        this.developedByLabel.setForeground(new Color(100, 100, 100));
        infoPanel.add(this.developedByLabel);
        connectionPanel.add((Component)infoPanel, "East");
        mainPanel.add((Component)connectionPanel, "North");
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerLocation(680);
        JPanel localPanel = this.createFilePanel("Local Directory", true);
        splitPane.setLeftComponent(localPanel);
        JPanel remotePanel = this.createFilePanel("Remote Directory", false);
        splitPane.setRightComponent(remotePanel);
        mainPanel.add((Component)splitPane, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel logPanel = new JPanel(new BorderLayout());
        logPanel.setBorder(BorderFactory.createTitledBorder("Activity Log"));
        this.logArea = new JTextArea(6, 50);
        this.logArea.setEditable(false);
        this.logArea.setFont(new Font("Consolas", 0, 11));
        JScrollPane logScroll = new JScrollPane(this.logArea);
        logPanel.add((Component)logScroll, "Center");
        JButton clearLogButton = new JButton("Clear Log");
        JPanel logButtonPanel = new JPanel(new FlowLayout(2));
        logButtonPanel.add(clearLogButton);
        logPanel.add((Component)logButtonPanel, "South");
        bottomPanel.add((Component)logPanel, "Center");
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setBorder(BorderFactory.createEtchedBorder());
        this.statusLabel = new JLabel(" Ready");
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 10));
        statusPanel.add((Component)this.statusLabel, "West");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(300, 20));
        this.progressBar.setVisible(false);
        statusPanel.add((Component)this.progressBar, "East");
        bottomPanel.add((Component)statusPanel, "South");
        mainPanel.add((Component)bottomPanel, "South");
        this.connectButton.addActionListener(e -> this.connect());
        this.disconnectButton.addActionListener(e -> this.disconnect());
        clearLogButton.addActionListener(e -> this.logArea.setText(""));
        this.setLocationRelativeTo(null);
    }

    private void customInit() {
        this.initIcons();
        this.setupTables();
        this.setupKeyboardShortcuts();
        this.setupDragAndDrop();
        this.refreshLocalFiles();
        this.styleButton(this.connectButton, CONNECT_BUTTON_BG);
        this.styleButton(this.disconnectButton, ACTION_BUTTON_BG);
    }

    private void styleButton(final JButton button, final Color bgColor) {
        button.setBackground(bgColor);
        button.setForeground(Color.BLACK);
        button.setFocusPainted(false);
        button.setOpaque(true);
        button.setContentAreaFilled(true);
        button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(bgColor.darker(), 1), BorderFactory.createEmptyBorder(5, 12, 5, 12)));
        button.setFont(new Font("Arial", 1, 12));
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (button.isEnabled()) {
                    button.setBackground(bgColor.brighter());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setBackground(bgColor);
            }
        });
    }

    private JPanel createFilePanel(String title, boolean isLocal) {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title, 0, 0, new Font("Arial", 1, 12)));
        JPanel navPanel = new JPanel(new BorderLayout(5, 5));
        navPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JTextField pathField = new JTextField();
        pathField.setEditable(false);
        pathField.setText(isLocal ? this.currentLocalPath : this.currentRemotePath);
        if (isLocal) {
            this.localPathField = pathField;
        } else {
            this.remotePathField = pathField;
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 5, 0));
        JButton upButton = this.createNavButton("\u2191", e -> {
            if (isLocal) {
                this.navigateLocalUp();
            } else {
                this.navigateRemoteUp();
            }
        }, "Go to parent directory");
        buttonPanel.add(upButton);
        JButton homeButton = this.createNavButton("\u2302", e -> {
            if (isLocal) {
                this.navigateLocalHome();
            } else {
                this.navigateRemoteHome();
            }
        }, "Go to home directory");
        buttonPanel.add(homeButton);
        JButton refreshButton = this.createNavButton("\u27f3", e -> {
            if (isLocal) {
                this.refreshLocalFiles();
            } else {
                this.refreshRemoteFiles();
            }
        }, "Refresh");
        buttonPanel.add(refreshButton);
        if (isLocal) {
            JButton browseButton = this.createNavButton("Browse...", e -> this.browseLocalFolder(), "Browse for folder");
            buttonPanel.add(browseButton);
        }
        navPanel.add((Component)buttonPanel, "West");
        navPanel.add((Component)pathField, "Center");
        panel.add((Component)navPanel, "North");
        Object[] columns = new String[]{"Name", "Size", "Type", "Modified"};
        DefaultTableModel model = new DefaultTableModel(columns, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 0) {
                    return Object.class;
                }
                return String.class;
            }
        };
        JTable table = new JTable(model);
        table.setSelectionMode(2);
        table.setRowHeight(22);
        table.setShowGrid(true);
        table.setGridColor(new Color(230, 230, 230));
        if (isLocal) {
            this.localTableModel = model;
            this.localFileTable = table;
        } else {
            this.remoteTableModel = model;
            this.remoteFileTable = table;
        }
        JScrollPane scrollPane = new JScrollPane(table);
        panel.add((Component)scrollPane, "Center");
        JPanel actionPanel = new JPanel(new FlowLayout(1, 10, 5));
        if (isLocal) {
            JButton uploadButton = this.createActionButton("Upload \u2192", UPLOAD_BUTTON_BG, e -> this.uploadSelectedFiles());
            actionPanel.add(uploadButton);
        } else {
            JButton downloadButton = this.createActionButton("\u2190 Download", DOWNLOAD_BUTTON_BG, e -> this.downloadSelectedFiles());
            actionPanel.add(downloadButton);
        }
        JButton deleteButton = this.createActionButton("Delete", ACTION_BUTTON_BG, e -> this.deleteSelectedFiles(isLocal));
        actionPanel.add(deleteButton);
        JButton newFolderButton = this.createActionButton("New Folder", ACTION_BUTTON_BG, e -> this.createNewFolder(isLocal));
        actionPanel.add(newFolderButton);
        JButton renameButton = this.createActionButton("Rename", ACTION_BUTTON_BG, e -> this.renameSelected(isLocal));
        actionPanel.add(renameButton);
        panel.add((Component)actionPanel, "South");
        return panel;
    }

    private JButton createNavButton(String text, ActionListener action, String tooltip) {
        JButton button = new JButton(text);
        button.setToolTipText(tooltip);
        button.addActionListener(action);
        this.styleButton(button, ACTION_BUTTON_BG);
        return button;
    }

    private JButton createActionButton(String text, Color bgColor, ActionListener action) {
        JButton button = new JButton(text);
        button.addActionListener(action);
        this.styleButton(button, bgColor);
        return button;
    }

    private void setupTables() {
        DefaultTableCellRenderer iconRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                DefaultTableModel m = (DefaultTableModel)table.getModel();
                String type = (String)m.getValueAt(row, 2);
                if ("Directory".equals(type) || "DIR".equals(type)) {
                    label.setIcon(SFTP_Free_Edition.this.folderIcon);
                } else {
                    label.setIcon(SFTP_Free_Edition.this.fileIcon);
                }
                return label;
            }
        };
        this.localFileTable.getColumnModel().getColumn(0).setCellRenderer(iconRenderer);
        this.remoteFileTable.getColumnModel().getColumn(0).setCellRenderer(iconRenderer);
        this.localFileTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.localFileTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.localFileTable.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.localFileTable.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.remoteFileTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.remoteFileTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.remoteFileTable.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.remoteFileTable.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.localFileTable.addMouseListener(this.createTableMouseListener(this.localFileTable, true));
        this.remoteFileTable.addMouseListener(this.createTableMouseListener(this.remoteFileTable, false));
        this.localFileTable.addKeyListener(this.createTableKeyListener(this.localFileTable, true));
        this.remoteFileTable.addKeyListener(this.createTableKeyListener(this.remoteFileTable, false));
    }

    private MouseAdapter createTableMouseListener(final JTable table, final boolean isLocal) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && (row = table.getSelectedRow()) >= 0) {
                    DefaultTableModel model = (DefaultTableModel)table.getModel();
                    FileEntry entry = (FileEntry)model.getValueAt(row, 0);
                    String type = (String)model.getValueAt(row, 2);
                    if ("Directory".equals(type) || "DIR".equals(type) || type.startsWith("DIR (") || "Link".equals(type)) {
                        if (isLocal) {
                            SFTP_Free_Edition.this.navigateLocalTo(entry.getName());
                        } else {
                            SFTP_Free_Edition.this.navigateRemoteTo(entry.getName());
                        }
                    }
                }
            }
        };
    }

    private KeyAdapter createTableKeyListener(final JTable table, final boolean isLocal) {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    int row = table.getSelectedRow();
                    if (row >= 0) {
                        DefaultTableModel model = (DefaultTableModel)table.getModel();
                        FileEntry entry = (FileEntry)model.getValueAt(row, 0);
                        String type = (String)model.getValueAt(row, 2);
                        if ("Directory".equals(type) || "DIR".equals(type) || type.startsWith("DIR (") || "Link".equals(type)) {
                            if (isLocal) {
                                SFTP_Free_Edition.this.navigateLocalTo(entry.getName());
                            } else {
                                SFTP_Free_Edition.this.navigateRemoteTo(entry.getName());
                            }
                        }
                    }
                    e.consume();
                }
            }
        };
    }

    private void setupDragAndDrop() {
        this.setupDragSource(this.localFileTable, true);
        this.setupDragSource(this.remoteFileTable, false);
        this.setupDropTarget(this.localFileTable, true);
        this.setupDropTarget(this.remoteFileTable, false);
    }

    private void initIcons() {
        try {
            this.folderIcon = new ImageIcon(this.createFolderIcon());
            this.fileIcon = new ImageIcon(this.createFileIcon());
        }
        catch (Exception e) {
            this.folderIcon = null;
            this.fileIcon = null;
        }
    }

    private Image createFolderIcon() {
        int size = 16;
        BufferedImage img = new BufferedImage(size, size, 2);
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(new Color(255, 215, 0));
        g2.fillRect(2, 6, size - 4, size - 8);
        g2.setColor(new Color(218, 165, 32));
        g2.drawRect(2, 6, size - 4, size - 8);
        g2.dispose();
        return img;
    }

    private Image createFileIcon() {
        int size = 16;
        BufferedImage img = new BufferedImage(size, size, 2);
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fillRect(3, 2, size - 7, size - 4);
        g2.setColor(Color.GRAY);
        g2.drawRect(3, 2, size - 7, size - 4);
        g2.dispose();
        return img;
    }

    private void setupDragSource(final JTable table, final boolean isLocal) {
        DragSource ds = new DragSource();
        ds.createDefaultDragGestureRecognizer(table, 1, new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                int[] rows = table.getSelectedRows();
                if (rows.length > 0) {
                    ArrayList<FileEntry> files = new ArrayList<FileEntry>();
                    DefaultTableModel model = (DefaultTableModel)table.getModel();
                    int[] nArray = rows;
                    int n = rows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int row = nArray[n2];
                        files.add((FileEntry)model.getValueAt(row, 0));
                        ++n2;
                    }
                    FileTransferable transferable = new FileTransferable(files, isLocal);
                    dge.startDrag(null, transferable);
                }
            }
        });
    }

    private void setupDropTarget(JTable table, final boolean isLocal) {
        new DropTarget(table, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    dtde.acceptDrop(1);
                    Transferable transferable = dtde.getTransferable();
                    DataFlavor internalFlavor = new DataFlavor(FileTransferable.class, "InternalFileTransfer");
                    if (transferable.isDataFlavorSupported(internalFlavor)) {
                        FileTransferable ft = (FileTransferable)transferable.getTransferData(internalFlavor);
                        if (ft.isLocal() && !isLocal && SFTP_Free_Edition.this.isConnected) {
                            SFTP_Free_Edition.this.log("Internal drag & drop: Uploading " + ft.getFiles().size() + " item(s)...");
                            ArrayList<FileEntry> filesToUpload = new ArrayList<FileEntry>(ft.getFiles());
                            new Thread(() -> {
                                int success = 0;
                                int failed = 0;
                                for (FileEntry entry : filesToUpload) {
                                    try {
                                        File file = new File(SFTP_Free_Edition.this.currentLocalPath, entry.getName());
                                        SFTP_Free_Edition.this.uploadFile(file);
                                        ++success;
                                    }
                                    catch (Exception e) {
                                        ++failed;
                                    }
                                }
                                SFTP_Free_Edition.this.log("Upload complete: " + success + " succeeded, " + failed + " failed");
                                SwingUtilities.invokeLater(() -> {
                                    SFTP_Free_Edition.this.refreshRemoteFiles();
                                    SFTP_Free_Edition.this.showProgress(false);
                                });
                            }).start();
                        } else if (!ft.isLocal() && isLocal && SFTP_Free_Edition.this.isConnected) {
                            SFTP_Free_Edition.this.log("Internal drag & drop: Downloading " + ft.getFiles().size() + " item(s)...");
                            ArrayList<FileEntry> filesToDownload = new ArrayList<FileEntry>(ft.getFiles());
                            new Thread(() -> {
                                int success = 0;
                                int failed = 0;
                                for (FileEntry entry : filesToDownload) {
                                    try {
                                        SFTP_Free_Edition.this.downloadFile(entry.getName(), entry.isDirectory());
                                        ++success;
                                    }
                                    catch (Exception e) {
                                        ++failed;
                                    }
                                }
                                SFTP_Free_Edition.this.log("Download complete: " + success + " succeeded, " + failed + " failed");
                                SwingUtilities.invokeLater(() -> {
                                    SFTP_Free_Edition.this.refreshLocalFiles();
                                    SFTP_Free_Edition.this.showProgress(false);
                                });
                            }).start();
                        }
                        dtde.dropComplete(true);
                        return;
                    }
                    if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        if (!isLocal && SFTP_Free_Edition.this.isConnected) {
                            SFTP_Free_Edition.this.log("External drag & drop: Uploading " + files.size() + " item(s)...");
                            ArrayList filesToUpload = new ArrayList(files);
                            new Thread(() -> {
                                int success = 0;
                                int failed = 0;
                                for (File file : filesToUpload) {
                                    try {
                                        SFTP_Free_Edition.this.uploadFile(file);
                                        ++success;
                                    }
                                    catch (Exception e) {
                                        ++failed;
                                    }
                                }
                                SFTP_Free_Edition.this.log("Upload complete: " + success + " succeeded, " + failed + " failed");
                                SwingUtilities.invokeLater(() -> {
                                    SFTP_Free_Edition.this.refreshRemoteFiles();
                                    SFTP_Free_Edition.this.showProgress(false);
                                });
                            }).start();
                        } else if (isLocal) {
                            SFTP_Free_Edition.this.log("External drag & drop: " + files.size() + " item(s) dropped on local panel");
                        }
                    }
                    dtde.dropComplete(true);
                }
                catch (Exception e) {
                    SFTP_Free_Edition.this.log("Drag & drop error: " + e.getMessage());
                    dtde.dropComplete(false);
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                if (!isLocal && !SFTP_Free_Edition.this.isConnected) {
                    dtde.rejectDrag();
                } else {
                    dtde.acceptDrag(1);
                }
            }

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                dtde.acceptDrag(1);
            }
        });
    }

    private void connect() {
        String host = this.hostField.getText().trim();
        String port = this.portField.getText().trim();
        String username = this.usernameField.getText().trim();
        String password = new String(this.passwordField.getPassword());
        if (host.isEmpty() || username.isEmpty()) {
            this.showError("Host and username are required");
            return;
        }
        new Thread(() -> {
            try {
                this.log("Connecting to " + host + ":" + port + "...");
                this.setStatus("Connecting...");
                JSch jsch = new JSch();
                this.session = jsch.getSession(username, host, Integer.parseInt(port));
                this.session.setPassword(password);
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", "no");
                this.session.setConfig(config);
                this.session.setTimeout(30000);
                this.session.connect();
                Channel channel = this.session.openChannel("sftp");
                channel.connect();
                this.sftpChannel = (ChannelSftp)channel;
                this.currentRemotePath = this.sftpChannel.pwd();
                this.isConnected = true;
                SwingUtilities.invokeLater(() -> {
                    this.connectButton.setEnabled(false);
                    this.disconnectButton.setEnabled(true);
                    this.hostField.setEnabled(false);
                    this.portField.setEnabled(false);
                    this.usernameField.setEnabled(false);
                    this.passwordField.setEnabled(false);
                    this.connectionStatusLabel.setText("\u25cf Connected to " + host);
                    this.connectionStatusLabel.setForeground(CONNECTED_COLOR);
                    this.remotePathField.setText(this.currentRemotePath);
                    this.log("Connected successfully to " + host);
                    this.setStatus("Connected");
                    this.refreshRemoteFiles();
                });
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(() -> {
                    this.log("Connection failed: " + e.getMessage());
                    this.setStatus("Connection failed");
                    this.showError("Connection failed: " + e.getMessage());
                });
            }
        }).start();
    }

    private void disconnect() {
        if (this.sftpChannel != null && this.sftpChannel.isConnected()) {
            this.sftpChannel.disconnect();
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
        this.isConnected = false;
        this.connectButton.setEnabled(true);
        this.disconnectButton.setEnabled(false);
        this.hostField.setEnabled(true);
        this.portField.setEnabled(true);
        this.usernameField.setEnabled(true);
        this.passwordField.setEnabled(true);
        this.connectionStatusLabel.setText("\u25cf Not Connected");
        this.connectionStatusLabel.setForeground(DISCONNECTED_COLOR);
        this.remoteTableModel.setRowCount(0);
        this.remotePathField.setText("");
        this.log("Disconnected");
        this.setStatus("Disconnected");
    }

    private void refreshLocalFiles() {
        this.localTableModel.setRowCount(0);
        File dir = new File(this.currentLocalPath);
        File[] files = dir.listFiles();
        if (files != null) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    if (f1.isDirectory() && !f2.isDirectory()) {
                        return -1;
                    }
                    if (!f1.isDirectory() && f2.isDirectory()) {
                        return 1;
                    }
                    return f1.getName().compareToIgnoreCase(f2.getName());
                }
            });
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            int count = 0;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileEntry entry = new FileEntry(file.getName(), file.isDirectory());
                String size = file.isDirectory() ? "" : this.formatFileSize(file.length());
                String type = file.isDirectory() ? "DIR" : this.getFileType(file.getName());
                String modified = sdf.format(new Date(file.lastModified()));
                this.localTableModel.addRow(new Object[]{entry, size, type, modified});
                ++count;
                ++n2;
            }
            this.localPathField.setText(this.currentLocalPath);
            this.log("Refreshed local: " + this.currentLocalPath + " (" + count + " items)");
        } else {
            this.log("Cannot read directory: " + this.currentLocalPath);
        }
    }

    private void refreshRemoteFiles() {
        if (!this.isConnected) {
            return;
        }
        new Thread(() -> {
            try {
                SwingUtilities.invokeLater(() -> this.remoteTableModel.setRowCount(0));
                Vector files = this.sftpChannel.ls(this.currentRemotePath);
                ArrayList<ChannelSftp.LsEntry> sortedFiles = new ArrayList<ChannelSftp.LsEntry>(files);
                sortedFiles.removeIf(entry -> ".".equals(entry.getFilename()) || "..".equals(entry.getFilename()));
                Collections.sort(sortedFiles, new Comparator<ChannelSftp.LsEntry>(){

                    @Override
                    public int compare(ChannelSftp.LsEntry e1, ChannelSftp.LsEntry e2) {
                        boolean d2;
                        boolean d1 = e1.getAttrs().isDir() || e1.getAttrs().isLink();
                        boolean bl = d2 = e2.getAttrs().isDir() || e2.getAttrs().isLink();
                        if (d1 && !d2) {
                            return -1;
                        }
                        if (!d1 && d2) {
                            return 1;
                        }
                        return e1.getFilename().compareToIgnoreCase(e2.getFilename());
                    }
                });
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (ChannelSftp.LsEntry entry2 : sortedFiles) {
                    String size;
                    String name = entry2.getFilename();
                    SftpATTRS attrs = entry2.getAttrs();
                    boolean isDir = attrs.isDir();
                    boolean isLink = attrs.isLink();
                    if (isLink && !isDir) {
                        try {
                            String fullPath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + name : String.valueOf(this.currentRemotePath) + "/" + name;
                            SftpATTRS linkAttrs = this.sftpChannel.stat(fullPath);
                            isDir = linkAttrs.isDir();
                        }
                        catch (Exception fullPath) {
                            // empty catch block
                        }
                    }
                    FileEntry fileEntry = new FileEntry(name, isDir);
                    String string = size = isDir ? "" : this.formatFileSize(attrs.getSize());
                    String type = isLink && isDir ? "DIR (Link)" : (isLink ? "Link" : (isDir ? "DIR" : this.getFileType(name)));
                    String modified = sdf.format(new Date((long)attrs.getMTime() * 1000L));
                    SwingUtilities.invokeLater(() -> this.remoteTableModel.addRow(new Object[]{fileEntry, size, type, modified}));
                }
                SwingUtilities.invokeLater(() -> this.remotePathField.setText(this.currentRemotePath));
                this.log("Refreshed remote: " + this.currentRemotePath + " (" + sortedFiles.size() + " items)");
            }
            catch (Exception e) {
                this.log("Error refreshing remote: " + e.getMessage());
                SwingUtilities.invokeLater(() -> this.showError("Error refreshing: " + e.getMessage()));
            }
        }).start();
    }

    private void navigateLocalTo(String name) {
        File newDir = new File(this.currentLocalPath, name);
        if (newDir.exists() && newDir.isDirectory()) {
            try {
                this.currentLocalPath = newDir.getCanonicalPath();
                this.refreshLocalFiles();
            }
            catch (IOException e) {
                this.log("Navigation error: " + e.getMessage());
            }
        }
    }

    private void navigateLocalUp() {
        File current = new File(this.currentLocalPath);
        File parent = current.getParentFile();
        if (parent != null) {
            this.currentLocalPath = parent.getAbsolutePath();
            this.refreshLocalFiles();
        }
    }

    private void navigateLocalHome() {
        this.currentLocalPath = System.getProperty("user.home");
        this.refreshLocalFiles();
    }

    private void browseLocalFolder() {
        JFileChooser fileChooser = new JFileChooser(this.currentLocalPath);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle("Select Folder");
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            File selectedFolder = fileChooser.getSelectedFile();
            this.currentLocalPath = selectedFolder.getAbsolutePath();
            this.refreshLocalFiles();
            this.log("Browsed to: " + this.currentLocalPath);
        }
    }

    private void navigateRemoteTo(String name) {
        if (!this.isConnected) {
            return;
        }
        new Thread(() -> {
            try {
                String newPath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + name : String.valueOf(this.currentRemotePath) + "/" + name;
                try {
                    this.sftpChannel.cd(newPath);
                    this.currentRemotePath = this.sftpChannel.pwd();
                    SwingUtilities.invokeLater(this::refreshRemoteFiles);
                    this.log("Navigated to: " + this.currentRemotePath);
                }
                catch (SftpException e) {
                    this.log("Cannot navigate to: " + name + " - " + e.getMessage());
                    SwingUtilities.invokeLater(() -> this.showError("Cannot open: " + name + "\n" + e.getMessage()));
                }
            }
            catch (Exception e) {
                this.log("Navigation error: " + e.getMessage());
                SwingUtilities.invokeLater(() -> this.showError("Navigation error: " + e.getMessage()));
            }
        }).start();
    }

    private void navigateRemoteUp() {
        if (!this.isConnected) {
            return;
        }
        new Thread(() -> {
            try {
                this.sftpChannel.cd("..");
                this.currentRemotePath = this.sftpChannel.pwd();
                SwingUtilities.invokeLater(this::refreshRemoteFiles);
            }
            catch (Exception e) {
                this.log("Navigation error: " + e.getMessage());
            }
        }).start();
    }

    private void navigateRemoteHome() {
        if (!this.isConnected) {
            return;
        }
        new Thread(() -> {
            try {
                this.sftpChannel.cd(this.sftpChannel.getHome());
                this.currentRemotePath = this.sftpChannel.pwd();
                SwingUtilities.invokeLater(this::refreshRemoteFiles);
            }
            catch (Exception e) {
                this.log("Navigation error: " + e.getMessage());
            }
        }).start();
    }

    private void uploadSelectedFiles() {
        if (!this.isConnected) {
            this.showError("Not connected to server");
            return;
        }
        int[] rows = this.localFileTable.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        ArrayList<File> filesToUpload = new ArrayList<File>();
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            FileEntry entry = (FileEntry)this.localTableModel.getValueAt(row, 0);
            File file = new File(this.currentLocalPath, entry.getName());
            filesToUpload.add(file);
            ++n2;
        }
        new Thread(() -> {
            this.log("Starting upload of " + filesToUpload.size() + " item(s)...");
            int success = 0;
            int failed = 0;
            for (File file : filesToUpload) {
                try {
                    this.uploadFile(file);
                    ++success;
                }
                catch (Exception e) {
                    this.log("\u2717 Upload error: " + file.getName() + " - " + e.getMessage());
                    ++failed;
                }
            }
            this.log("Upload complete: " + success + " succeeded, " + failed + " failed");
            SwingUtilities.invokeLater(() -> {
                this.refreshRemoteFiles();
                this.showProgress(false);
            });
        }).start();
    }

    private void uploadFile(File file) {
        try {
            if (file.isDirectory()) {
                this.uploadDirectory(file, this.currentRemotePath);
            } else {
                this.log("Uploading: " + file.getName() + " (" + this.formatFileSize(file.length()) + ")");
                this.showProgress(true);
                String remotePath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + file.getName() : String.valueOf(this.currentRemotePath) + "/" + file.getName();
                FileProgressMonitor monitor = new FileProgressMonitor(file.length(), file.getName());
                this.sftpChannel.put(file.getAbsolutePath(), remotePath, (SftpProgressMonitor)monitor, 0);
                this.log("\u2713 Upload complete: " + file.getName());
                this.showProgress(false);
            }
        }
        catch (Exception e) {
            this.log("\u2717 Upload failed: " + file.getName() + " - " + e.getMessage());
            this.showProgress(false);
            throw new RuntimeException(e);
        }
    }

    private void uploadDirectory(File dir, String remoteBasePath) {
        try {
            String remoteDirPath;
            block10: {
                remoteDirPath = remoteBasePath.endsWith("/") ? String.valueOf(remoteBasePath) + dir.getName() : String.valueOf(remoteBasePath) + "/" + dir.getName();
                try {
                    this.sftpChannel.mkdir(remoteDirPath);
                    this.log("\u2713 Created remote directory: " + dir.getName());
                }
                catch (SftpException e) {
                    if (e.id == 4) break block10;
                    this.log("Directory already exists: " + dir.getName());
                }
            }
            File[] files = dir.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        this.uploadDirectory(file, remoteDirPath);
                    } else {
                        try {
                            this.log("Uploading: " + file.getName() + " (" + this.formatFileSize(file.length()) + ")");
                            this.showProgress(true);
                            String remoteFilePath = remoteDirPath.endsWith("/") ? String.valueOf(remoteDirPath) + file.getName() : String.valueOf(remoteDirPath) + "/" + file.getName();
                            FileProgressMonitor monitor = new FileProgressMonitor(file.length(), file.getName());
                            this.sftpChannel.put(file.getAbsolutePath(), remoteFilePath, (SftpProgressMonitor)monitor, 0);
                            this.log("\u2713 Uploaded: " + file.getName());
                            this.showProgress(false);
                        }
                        catch (Exception e) {
                            this.log("\u2717 Failed to upload: " + file.getName() + " - " + e.getMessage());
                            this.showProgress(false);
                        }
                    }
                    ++n2;
                }
            }
            this.log("\u2713 Folder upload complete: " + dir.getName());
        }
        catch (Exception e) {
            this.log("\u2717 Error uploading directory: " + dir.getName() + " - " + e.getMessage());
            this.showProgress(false);
        }
    }

    private void downloadSelectedFiles() {
        if (!this.isConnected) {
            this.showError("Not connected to server");
            return;
        }
        int[] rows = this.remoteFileTable.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        ArrayList<FileDownloadInfo> filesToDownload = new ArrayList<FileDownloadInfo>();
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            FileEntry entry = (FileEntry)this.remoteTableModel.getValueAt(row, 0);
            filesToDownload.add(new FileDownloadInfo(entry.getName(), entry.isDirectory()));
            ++n2;
        }
        new Thread(() -> {
            this.log("Starting download of " + filesToDownload.size() + " item(s)...");
            int success = 0;
            int failed = 0;
            for (FileDownloadInfo info : filesToDownload) {
                try {
                    this.downloadFile(info.name, info.isDirectory);
                    ++success;
                }
                catch (Exception e) {
                    this.log("\u2717 Download error: " + info.name + " - " + e.getMessage());
                    ++failed;
                }
            }
            this.log("Download complete: " + success + " succeeded, " + failed + " failed");
            SwingUtilities.invokeLater(() -> {
                this.refreshLocalFiles();
                this.showProgress(false);
            });
        }).start();
    }

    private void downloadFile(String filename, boolean isDirectory) {
        try {
            String remotePath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + filename : String.valueOf(this.currentRemotePath) + "/" + filename;
            String localPath = String.valueOf(this.currentLocalPath) + File.separator + filename;
            if (isDirectory) {
                this.downloadDirectory(remotePath, localPath);
            } else {
                SftpATTRS attrs = this.sftpChannel.stat(remotePath);
                this.log("Downloading: " + filename + " (" + this.formatFileSize(attrs.getSize()) + ")");
                this.showProgress(true);
                FileProgressMonitor monitor = new FileProgressMonitor(attrs.getSize(), filename);
                this.sftpChannel.get(remotePath, localPath, monitor, 0);
                this.log("\u2713 Download complete: " + filename);
                this.showProgress(false);
            }
        }
        catch (Exception e) {
            this.log("\u2717 Download failed: " + filename + " - " + e.getMessage());
            this.showProgress(false);
            throw new RuntimeException(e);
        }
    }

    private void downloadDirectory(String remotePath, String localPath) {
        try {
            File localDir = new File(localPath);
            if (!localDir.exists()) {
                if (localDir.mkdirs()) {
                    this.log("\u2713 Created local directory: " + localDir.getName());
                } else {
                    this.log("\u2717 Failed to create local directory: " + localDir.getName());
                    return;
                }
            }
            Vector files = this.sftpChannel.ls(remotePath);
            for (ChannelSftp.LsEntry entry : files) {
                String name = entry.getFilename();
                if (".".equals(name) || "..".equals(name)) continue;
                String newRemotePath = String.valueOf(remotePath) + "/" + name;
                String newLocalPath = String.valueOf(localPath) + File.separator + name;
                if (entry.getAttrs().isDir()) {
                    this.downloadDirectory(newRemotePath, newLocalPath);
                    continue;
                }
                try {
                    SftpATTRS attrs = entry.getAttrs();
                    this.log("Downloading: " + name + " (" + this.formatFileSize(attrs.getSize()) + ")");
                    this.showProgress(true);
                    FileProgressMonitor monitor = new FileProgressMonitor(attrs.getSize(), name);
                    this.sftpChannel.get(newRemotePath, newLocalPath, monitor, 0);
                    this.log("\u2713 Downloaded: " + name);
                    this.showProgress(false);
                }
                catch (Exception e) {
                    this.log("\u2717 Failed to download: " + name + " - " + e.getMessage());
                    this.showProgress(false);
                }
            }
            this.log("\u2713 Folder download complete: " + new File(localPath).getName());
        }
        catch (Exception e) {
            this.log("\u2717 Error downloading directory: " + e.getMessage());
            this.showProgress(false);
        }
    }

    private void deleteSelectedFiles(boolean isLocal) {
        JTable table = isLocal ? this.localFileTable : this.remoteFileTable;
        int[] rows = table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        int confirm = JOptionPane.showConfirmDialog(this, "Delete " + rows.length + " item(s)?", "Confirm Delete", 0, 2);
        if (confirm != 0) {
            return;
        }
        new Thread(() -> {
            DefaultTableModel model = isLocal ? this.localTableModel : this.remoteTableModel;
            int[] nArray2 = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray2[n2];
                FileEntry entry = (FileEntry)model.getValueAt(row, 0);
                try {
                    if (isLocal) {
                        File file = new File(this.currentLocalPath, entry.getName());
                        this.deleteLocalFile(file);
                        this.log("\u2713 Deleted local: " + entry.getName());
                    } else if (this.isConnected) {
                        String remotePath;
                        String string = remotePath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + entry.getName() : String.valueOf(this.currentRemotePath) + "/" + entry.getName();
                        if (entry.isDirectory()) {
                            this.deleteRemoteDirectory(remotePath);
                        } else {
                            this.sftpChannel.rm(remotePath);
                        }
                        this.log("\u2713 Deleted remote: " + entry.getName());
                    }
                }
                catch (Exception e) {
                    this.log("\u2717 Delete failed: " + entry.getName() + " - " + e.getMessage());
                }
                ++n2;
            }
            SwingUtilities.invokeLater(() -> {
                if (isLocal) {
                    this.refreshLocalFiles();
                } else {
                    this.refreshRemoteFiles();
                }
            });
        }).start();
    }

    private void deleteLocalFile(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.deleteLocalFile(f);
                ++n2;
            }
        }
        file.delete();
    }

    private void deleteRemoteDirectory(String path) throws SftpException {
        Vector files = this.sftpChannel.ls(path);
        for (ChannelSftp.LsEntry entry : files) {
            String name = entry.getFilename();
            if (".".equals(name) || "..".equals(name)) continue;
            String filePath = String.valueOf(path) + "/" + name;
            if (entry.getAttrs().isDir()) {
                this.deleteRemoteDirectory(filePath);
                continue;
            }
            this.sftpChannel.rm(filePath);
        }
        this.sftpChannel.rmdir(path);
    }

    private void renameSelected(boolean isLocal) {
        JTable table = isLocal ? this.localFileTable : this.remoteFileTable;
        int row = table.getSelectedRow();
        if (row < 0) {
            return;
        }
        DefaultTableModel model = isLocal ? this.localTableModel : this.remoteTableModel;
        FileEntry entry = (FileEntry)model.getValueAt(row, 0);
        String oldName = entry.getName();
        String newName = JOptionPane.showInputDialog(this, "New name:", oldName);
        if (newName == null || newName.trim().isEmpty() || newName.equals(oldName)) {
            return;
        }
        new Thread(() -> {
            try {
                if (isLocal) {
                    File oldFile = new File(this.currentLocalPath, oldName);
                    File newFile = new File(this.currentLocalPath, newName);
                    if (oldFile.renameTo(newFile)) {
                        this.log("\u2713 Renamed local: " + oldName + " \u2192 " + newName);
                        SwingUtilities.invokeLater(this::refreshLocalFiles);
                    }
                } else {
                    if (!this.isConnected) {
                        return;
                    }
                    String oldPath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + oldName : String.valueOf(this.currentRemotePath) + "/" + oldName;
                    String newPath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + newName : String.valueOf(this.currentRemotePath) + "/" + newName;
                    this.sftpChannel.rename(oldPath, newPath);
                    this.log("\u2713 Renamed remote: " + oldName + " \u2192 " + newName);
                    SwingUtilities.invokeLater(this::refreshRemoteFiles);
                }
            }
            catch (Exception e) {
                this.log("\u2717 Rename failed: " + e.getMessage());
                SwingUtilities.invokeLater(() -> this.showError("Rename failed: " + e.getMessage()));
            }
        }).start();
    }

    private void createNewFolder(boolean isLocal) {
        String folderName = JOptionPane.showInputDialog(this, (Object)"Enter folder name:");
        if (folderName == null || folderName.trim().isEmpty()) {
            return;
        }
        new Thread(() -> {
            try {
                if (isLocal) {
                    File newFolder = new File(this.currentLocalPath, folderName);
                    if (newFolder.mkdir()) {
                        this.log("\u2713 Created local folder: " + folderName);
                        SwingUtilities.invokeLater(this::refreshLocalFiles);
                    }
                } else {
                    if (!this.isConnected) {
                        return;
                    }
                    String remotePath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + folderName : String.valueOf(this.currentRemotePath) + "/" + folderName;
                    this.sftpChannel.mkdir(remotePath);
                    this.log("\u2713 Created remote folder: " + folderName);
                    SwingUtilities.invokeLater(this::refreshRemoteFiles);
                }
            }
            catch (Exception e) {
                this.log("\u2717 Create folder failed: " + e.getMessage());
                SwingUtilities.invokeLater(() -> this.showError("Create folder failed: " + e.getMessage()));
            }
        }).start();
    }

    private void showProperties(boolean isLocal, JTable table) {
        int row = table.getSelectedRow();
        if (row < 0) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        FileEntry entry = (FileEntry)model.getValueAt(row, 0);
        String size = (String)model.getValueAt(row, 1);
        String type = (String)model.getValueAt(row, 2);
        String modified = (String)model.getValueAt(row, 3);
        StringBuilder props = new StringBuilder();
        props.append("Name: ").append(entry.getName()).append("\n");
        props.append("Type: ").append(type).append("\n");
        props.append("Size: ").append(size.isEmpty() ? "N/A" : size).append("\n");
        props.append("Modified: ").append(modified).append("\n");
        if (isLocal) {
            File file = new File(this.currentLocalPath, entry.getName());
            props.append("Path: ").append(file.getAbsolutePath()).append("\n");
            props.append("Readable: ").append(file.canRead()).append("\n");
            props.append("Writable: ").append(file.canWrite()).append("\n");
        } else {
            String remotePath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + entry.getName() : String.valueOf(this.currentRemotePath) + "/" + entry.getName();
            props.append("Path: ").append(remotePath).append("\n");
        }
        JTextArea textArea = new JTextArea(props.toString());
        textArea.setEditable(false);
        textArea.setFont(new Font("Monospaced", 0, 12));
        JOptionPane.showMessageDialog(this, new JScrollPane(textArea), "Properties - " + entry.getName(), 1);
    }

    private String formatFileSize(long size) {
        if (size < 1024L) {
            return String.valueOf(size) + " B";
        }
        if (size < 0x100000L) {
            return String.format("%.2f KB", (double)size / 1024.0);
        }
        if (size < 0x40000000L) {
            return String.format("%.2f MB", (double)size / 1048576.0);
        }
        return String.format("%.2f GB", (double)size / 1.073741824E9);
    }

    private String getFileType(String filename) {
        int lastDot = filename.lastIndexOf(46);
        if (lastDot > 0 && lastDot < filename.length() - 1) {
            return filename.substring(lastDot + 1).toUpperCase();
        }
        return "File";
    }

    private void log(String message) {
        SwingUtilities.invokeLater(() -> {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            this.logArea.append("[" + sdf.format(new Date()) + "] " + message + "\n");
            this.logArea.setCaretPosition(this.logArea.getDocument().getLength());
        });
    }

    private void setStatus(String status) {
        SwingUtilities.invokeLater(() -> this.statusLabel.setText(" " + status));
    }

    private void showProgress(boolean show) {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setVisible(show);
            if (!show) {
                this.progressBar.setValue(0);
                this.progressBar.setString("");
            }
        });
    }

    private void showError(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    private void setupKeyboardShortcuts() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(116, 0), "refresh");
        this.getRootPane().getActionMap().put("refresh", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SFTP_Free_Edition.this.refreshLocalFiles();
                if (SFTP_Free_Edition.this.isConnected) {
                    SFTP_Free_Edition.this.refreshRemoteFiles();
                }
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getRootPane().getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SFTP_Free_Edition.this.localFileTable.hasFocus()) {
                    SFTP_Free_Edition.this.deleteSelectedFiles(true);
                } else if (SFTP_Free_Edition.this.remoteFileTable.hasFocus()) {
                    SFTP_Free_Edition.this.deleteSelectedFiles(false);
                }
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(113, 0), "rename");
        this.getRootPane().getActionMap().put("rename", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SFTP_Free_Edition.this.localFileTable.hasFocus()) {
                    SFTP_Free_Edition.this.renameSelected(true);
                } else if (SFTP_Free_Edition.this.remoteFileTable.hasFocus()) {
                    SFTP_Free_Edition.this.renameSelected(false);
                }
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(8, 0), "parent");
        this.getRootPane().getActionMap().put("parent", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SFTP_Free_Edition.this.localFileTable.hasFocus()) {
                    SFTP_Free_Edition.this.navigateLocalUp();
                } else if (SFTP_Free_Edition.this.remoteFileTable.hasFocus()) {
                    SFTP_Free_Edition.this.navigateRemoteUp();
                }
            }
        });
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(() -> {
            SFTP_Free_Edition client = new SFTP_Free_Edition();
            client.setVisible(true);
        });
    }

    private static class FileDownloadInfo {
        String name;
        boolean isDirectory;

        FileDownloadInfo(String name, boolean isDirectory) {
            this.name = name;
            this.isDirectory = isDirectory;
        }
    }

    class FileEntry {
        private String name;
        private boolean isDirectory;

        public FileEntry(String name, boolean isDirectory) {
            this.name = name;
            this.isDirectory = isDirectory;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public String toString() {
            return this.name;
        }
    }

    class FileProgressMonitor
    implements SftpProgressMonitor {
        private long max;
        private long count;
        private String filename;
        private long lastUpdate;

        public FileProgressMonitor(long max, String filename) {
            this.max = max;
            this.filename = filename;
            this.count = 0L;
            this.lastUpdate = System.currentTimeMillis();
        }

        @Override
        public void init(int op, String src, String dest, long max) {
            this.max = max;
            this.count = 0L;
        }

        @Override
        public boolean count(long count) {
            this.count += count;
            long now = System.currentTimeMillis();
            if (now - this.lastUpdate > 100L) {
                int percent = this.max > 0L ? (int)(this.count * 100L / this.max) : 0;
                String progress = String.format("%s - %d%% (%s / %s)", this.filename, percent, SFTP_Free_Edition.this.formatFileSize(this.count), SFTP_Free_Edition.this.formatFileSize(this.max));
                SwingUtilities.invokeLater(() -> {
                    SFTP_Free_Edition.this.progressBar.setValue(percent);
                    SFTP_Free_Edition.this.progressBar.setString(progress);
                });
                this.lastUpdate = now;
            }
            return true;
        }

        @Override
        public void end() {
            SwingUtilities.invokeLater(() -> {
                SFTP_Free_Edition.this.progressBar.setValue(100);
                SFTP_Free_Edition.this.progressBar.setString(String.valueOf(this.filename) + " - Complete");
            });
        }
    }

    class FileTransferable
    implements Transferable {
        private List<FileEntry> files;
        private boolean isLocal;
        private final DataFlavor INTERNAL_FLAVOR = new DataFlavor(FileTransferable.class, "InternalFileTransfer");

        public FileTransferable(List<FileEntry> files, boolean isLocal) {
            this.files = files;
            this.isLocal = isLocal;
        }

        public List<FileEntry> getFiles() {
            return this.files;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (this.isLocal) {
                ArrayList<File> fileList = new ArrayList<File>();
                for (FileEntry entry : this.files) {
                    fileList.add(new File(SFTP_Free_Edition.this.currentLocalPath, entry.getName()));
                }
                return new DataFlavor[]{this.INTERNAL_FLAVOR, DataFlavor.javaFileListFlavor};
            }
            return new DataFlavor[]{this.INTERNAL_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (this.INTERNAL_FLAVOR.equals(flavor)) {
                return true;
            }
            return this.isLocal && DataFlavor.javaFileListFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (this.INTERNAL_FLAVOR.equals(flavor)) {
                return this;
            }
            if (this.isLocal && DataFlavor.javaFileListFlavor.equals(flavor)) {
                ArrayList<File> fileList = new ArrayList<File>();
                for (FileEntry entry : this.files) {
                    fileList.add(new File(SFTP_Free_Edition.this.currentLocalPath, entry.getName()));
                }
                return fileList;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

