/*
 * Decompiled with CFR 0.152.
 */
package testing_maven;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class SFTP
extends JFrame {
    private JTextField hostField;
    private JTextField portField;
    private JTextField usernameField;
    private JTextField localPathField;
    private JTextField remotePathField;
    private JPasswordField passwordField;
    private JComboBox<ConnectionProfile> profileComboBox;
    private JButton connectButton;
    private JButton disconnectButton;
    private JButton saveProfileButton;
    private JButton deleteProfileButton;
    private JTabbedPane connectionTabs;
    private JTable localFileTable;
    private JTable remoteFileTable;
    private DefaultTableModel localTableModel;
    private DefaultTableModel remoteTableModel;
    private JProgressBar progressBar;
    private JTextArea logArea;
    private JLabel statusLabel;
    private JLabel connectionStatusLabel;
    private JTextField searchField;
    private JToggleButton darkModeToggle;
    private Session session;
    private ChannelSftp sftpChannel;
    private String currentLocalPath;
    private String currentRemotePath;
    private boolean isConnected = false;
    private ImageIcon folderIcon;
    private ImageIcon fileIcon;
    private static Color CONNECTED_COLOR = new Color(34, 139, 34);
    private static Color DISCONNECTED_COLOR = new Color(178, 34, 34);
    private static Color BACKGROUND_COLOR = Color.WHITE;
    private static Color FOREGROUND_COLOR = Color.BLACK;
    private static Color PANEL_BG_COLOR = new Color(240, 240, 240);
    private static Color TABLE_BG_COLOR = Color.WHITE;
    private static Color TABLE_ALT_BG_COLOR = new Color(245, 245, 245);
    private static Color SELECTION_BG_COLOR = new Color(0, 123, 255);
    private static boolean isDarkMode = false;
    private static final String PROFILES_FILE = String.valueOf(System.getProperty("user.home")) + File.separator + ".sftp_profiles.dat";
    private List<ConnectionProfile> savedProfiles = new ArrayList<ConnectionProfile>();
    private Map<Integer, ConnectionData> tabConnections = new HashMap<Integer, ConnectionData>();
    private int currentTabId = 0;
    private List<SearchResult> currentSearchResults = new ArrayList<SearchResult>();
    private int currentSearchIndex = -1;

    public SFTP() {
        this.setTitle("SFTP Client - Professional Edition");
        this.setSize(1400, 900);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.currentLocalPath = System.getProperty("user.home");
        this.currentRemotePath = "/";
        this.loadProfiles();
        this.initIcons();
        this.initComponents();
        this.setupKeyboardShortcuts();
        this.applyTheme();
    }

    private void initIcons() {
        try {
            this.folderIcon = new ImageIcon(this.createFolderIcon());
            this.fileIcon = new ImageIcon(this.createFileIcon());
        }
        catch (Exception e) {
            this.folderIcon = null;
            this.fileIcon = null;
        }
    }

    private Image createFolderIcon() {
        int size = 16;
        BufferedImage img = new BufferedImage(size, size, 2);
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(isDarkMode ? new Color(255, 215, 0) : new Color(255, 215, 0));
        g2.fillRect(2, 6, size - 4, size - 8);
        g2.setColor(isDarkMode ? new Color(218, 165, 32) : new Color(218, 165, 32));
        g2.drawRect(2, 6, size - 4, size - 8);
        g2.dispose();
        return img;
    }

    private Image createFileIcon() {
        int size = 16;
        BufferedImage img = new BufferedImage(size, size, 2);
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(isDarkMode ? new Color(200, 200, 200) : Color.WHITE);
        g2.fillRect(3, 2, size - 7, size - 4);
        g2.setColor(isDarkMode ? new Color(150, 150, 150) : Color.GRAY);
        g2.drawRect(3, 2, size - 7, size - 4);
        g2.dispose();
        return img;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.createTopPanel(), "North");
        this.add((Component)this.createTabbedPanel(), "Center");
        this.add((Component)this.createBottomPanel(), "South");
        this.refreshLocalFiles();
    }

    private JPanel createTopPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setBackground(PANEL_BG_COLOR);
        JPanel profilePanel = new JPanel(new FlowLayout(0, 5, 5));
        profilePanel.setBackground(PANEL_BG_COLOR);
        profilePanel.add(new JLabel("Profile:"));
        this.profileComboBox = new JComboBox();
        this.profileComboBox.setPreferredSize(new Dimension(150, 25));
        this.profileComboBox.addActionListener(e -> this.loadSelectedProfile());
        this.refreshProfileComboBox();
        profilePanel.add(this.profileComboBox);
        this.saveProfileButton = new JButton("Save");
        this.saveProfileButton.setToolTipText("Save current connection settings as profile");
        this.saveProfileButton.addActionListener(e -> this.saveCurrentProfile());
        profilePanel.add(this.saveProfileButton);
        this.deleteProfileButton = new JButton("Delete");
        this.deleteProfileButton.setToolTipText("Delete selected profile");
        this.deleteProfileButton.addActionListener(e -> this.deleteSelectedProfile());
        profilePanel.add(this.deleteProfileButton);
        panel.add((Component)profilePanel, "West");
        JPanel fieldsPanel = new JPanel(new FlowLayout(0, 10, 5));
        fieldsPanel.setBackground(PANEL_BG_COLOR);
        fieldsPanel.add(new JLabel("Host:"));
        this.hostField = new JTextField("localhost", 15);
        fieldsPanel.add(this.hostField);
        fieldsPanel.add(new JLabel("Port:"));
        this.portField = new JTextField("22", 5);
        fieldsPanel.add(this.portField);
        fieldsPanel.add(new JLabel("Username:"));
        this.usernameField = new JTextField(12);
        fieldsPanel.add(this.usernameField);
        fieldsPanel.add(new JLabel("Password:"));
        this.passwordField = new JPasswordField(12);
        fieldsPanel.add(this.passwordField);
        this.connectButton = new JButton("Connect");
        this.connectButton.setBackground(new Color(0, 123, 255));
        this.connectButton.setForeground(Color.WHITE);
        this.connectButton.setFocusPainted(false);
        this.connectButton.addActionListener(e -> this.connect());
        fieldsPanel.add(this.connectButton);
        this.disconnectButton = new JButton("Disconnect");
        this.disconnectButton.setEnabled(false);
        this.disconnectButton.setFocusPainted(false);
        this.disconnectButton.addActionListener(e -> this.disconnect());
        fieldsPanel.add(this.disconnectButton);
        this.connectionStatusLabel = new JLabel("\u25cf Not Connected");
        this.connectionStatusLabel.setForeground(DISCONNECTED_COLOR);
        this.connectionStatusLabel.setFont(new Font("Arial", 1, 12));
        fieldsPanel.add(this.connectionStatusLabel);
        panel.add((Component)fieldsPanel, "Center");
        JPanel themePanel = new JPanel(new FlowLayout(2, 5, 5));
        themePanel.setBackground(PANEL_BG_COLOR);
        this.darkModeToggle = new JToggleButton("\ud83c\udf19 Dark");
        this.darkModeToggle.setToolTipText("Toggle Dark Mode");
        this.darkModeToggle.addActionListener(e -> this.toggleDarkMode());
        themePanel.add(this.darkModeToggle);
        panel.add((Component)themePanel, "East");
        return panel;
    }

    private JPanel createTabbedPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(BACKGROUND_COLOR);
        JPanel searchPanel = new JPanel(new FlowLayout(0, 5, 5));
        searchPanel.setBackground(PANEL_BG_COLOR);
        searchPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        searchPanel.add(new JLabel("\ud83d\udd0d Search:"));
        this.searchField = new JTextField(20);
        this.searchField.setToolTipText("Search files in current directory (Enter to search)");
        this.searchField.addActionListener(e -> this.performSearch());
        searchPanel.add(this.searchField);
        JButton searchButton = new JButton("Find");
        searchButton.addActionListener(e -> this.performSearch());
        searchPanel.add(searchButton);
        JButton clearSearchButton = new JButton("Clear");
        clearSearchButton.addActionListener(e -> this.clearSearch());
        searchPanel.add(clearSearchButton);
        JButton prevButton = new JButton("\u2191 Prev");
        prevButton.addActionListener(e -> this.navigateSearchResult(-1));
        searchPanel.add(prevButton);
        JButton nextButton = new JButton("\u2193 Next");
        nextButton.addActionListener(e -> this.navigateSearchResult(1));
        searchPanel.add(nextButton);
        JLabel searchStatusLabel = new JLabel(" ");
        searchStatusLabel.setName("searchStatus");
        searchPanel.add(searchStatusLabel);
        JButton newTabButton = new JButton("+ New Tab");
        newTabButton.setToolTipText("Open new connection tab");
        newTabButton.addActionListener(e -> this.createNewTab());
        searchPanel.add(Box.createHorizontalStrut(20));
        searchPanel.add(newTabButton);
        panel.add((Component)searchPanel, "North");
        this.connectionTabs = new JTabbedPane();
        this.connectionTabs.setBackground(BACKGROUND_COLOR);
        this.connectionTabs.setForeground(FOREGROUND_COLOR);
        this.createNewTab();
        panel.add((Component)this.connectionTabs, "Center");
        return panel;
    }

    private void createNewTab() {
        int tabId = this.currentTabId++;
        String tabTitle = "Session " + tabId;
        JPanel tabPanel = this.createFileBrowserPanel(tabId);
        this.connectionTabs.addTab(tabTitle, tabPanel);
        this.connectionTabs.setTabComponentAt(this.connectionTabs.getTabCount() - 1, this.createTabComponent(tabId, tabTitle));
        ConnectionData connData = new ConnectionData();
        connData.tabId = tabId;
        connData.localPath = this.currentLocalPath;
        connData.remotePath = "/";
        this.tabConnections.put(tabId, connData);
        this.connectionTabs.setSelectedIndex(this.connectionTabs.getTabCount() - 1);
    }

    private JPanel createFileBrowserPanel(int tabId) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(BACKGROUND_COLOR);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerLocation(680);
        splitPane.setBackground(BACKGROUND_COLOR);
        JPanel localPanel = this.createFilePanel("Local Directory", true, tabId);
        splitPane.setLeftComponent(localPanel);
        JPanel remotePanel = this.createFilePanel("Remote Directory", false, tabId);
        splitPane.setRightComponent(remotePanel);
        panel.add((Component)splitPane, "Center");
        return panel;
    }

    private JPanel createTabComponent(int tabId, String title) {
        JPanel tabComponent = new JPanel(new FlowLayout(0, 0, 0));
        tabComponent.setOpaque(false);
        JLabel titleLabel = new JLabel(title);
        titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JButton closeButton = new JButton("\u00d7");
        closeButton.setFont(new Font("Arial", 1, 12));
        closeButton.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        closeButton.setContentAreaFilled(false);
        closeButton.setToolTipText("Close tab");
        closeButton.addActionListener(e -> this.closeTab(tabId));
        tabComponent.add(titleLabel);
        tabComponent.add(closeButton);
        return tabComponent;
    }

    private void closeTab(int tabId) {
        int index = this.findTabIndex(tabId);
        if (index >= 0 && this.connectionTabs.getTabCount() > 1) {
            ConnectionData connData = this.tabConnections.get(tabId);
            if (connData != null && connData.isConnected) {
                this.disconnectTab(tabId);
            }
            this.connectionTabs.removeTabAt(index);
            this.tabConnections.remove(tabId);
        } else if (this.connectionTabs.getTabCount() == 1) {
            JOptionPane.showMessageDialog(this, "Cannot close the last tab", "Warning", 2);
        }
    }

    private int findTabIndex(int tabId) {
        int i = 0;
        while (i < this.connectionTabs.getTabCount()) {
            JPanel tabPanel = (JPanel)this.connectionTabs.getComponentAt(i);
            ConnectionData data = this.tabConnections.get(tabId);
            if (data != null && tabPanel != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private JPanel createFilePanel(String title, final boolean isLocal, int tabId) {
        JButton deleteButton;
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title, 0, 0, new Font("Arial", 1, 12)));
        panel.setBackground(BACKGROUND_COLOR);
        JPanel navPanel = new JPanel(new BorderLayout(5, 5));
        navPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        navPanel.setBackground(PANEL_BG_COLOR);
        JTextField pathField = new JTextField();
        pathField.setEditable(false);
        pathField.setBackground(TABLE_BG_COLOR);
        pathField.setForeground(FOREGROUND_COLOR);
        pathField.setText(isLocal ? this.currentLocalPath : this.currentRemotePath);
        if (isLocal) {
            this.localPathField = pathField;
        } else {
            this.remotePathField = pathField;
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 5, 0));
        buttonPanel.setBackground(PANEL_BG_COLOR);
        JButton upButton = new JButton("\u2191");
        upButton.setToolTipText("Go to parent directory");
        upButton.addActionListener(e -> {
            if (isLocal) {
                this.navigateLocalUp();
            } else {
                this.navigateRemoteUp();
            }
        });
        buttonPanel.add(upButton);
        JButton homeButton = new JButton("\u2302");
        homeButton.setToolTipText("Go to home directory");
        homeButton.addActionListener(e -> {
            if (isLocal) {
                this.navigateLocalHome();
            } else {
                this.navigateRemoteHome();
            }
        });
        buttonPanel.add(homeButton);
        JButton refreshButton = new JButton("\u27f3");
        refreshButton.setToolTipText("Refresh");
        refreshButton.addActionListener(e -> {
            if (isLocal) {
                this.refreshLocalFiles();
            } else {
                this.refreshRemoteFiles();
            }
        });
        buttonPanel.add(refreshButton);
        if (isLocal) {
            JButton browseButton = new JButton("Browse...");
            browseButton.setToolTipText("Browse for folder");
            browseButton.addActionListener(e -> this.browseLocalFolder());
            buttonPanel.add(browseButton);
        }
        navPanel.add((Component)buttonPanel, "West");
        navPanel.add((Component)pathField, "Center");
        panel.add((Component)navPanel, "North");
        Object[] columns = new String[]{"Name", "Size", "Type", "Modified"};
        final DefaultTableModel model = new DefaultTableModel(columns, 0){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 0) {
                    return Object.class;
                }
                return String.class;
            }
        };
        final JTable table = new JTable(model);
        table.setSelectionMode(2);
        table.setRowHeight(22);
        table.setShowGrid(true);
        table.setGridColor(isDarkMode ? new Color(60, 60, 60) : new Color(230, 230, 230));
        table.setBackground(TABLE_BG_COLOR);
        table.setForeground(FOREGROUND_COLOR);
        table.setSelectionBackground(SELECTION_BG_COLOR);
        table.setSelectionForeground(Color.WHITE);
        table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    c.setBackground(row % 2 == 0 ? TABLE_BG_COLOR : TABLE_ALT_BG_COLOR);
                    c.setForeground(FOREGROUND_COLOR);
                }
                return c;
            }
        });
        table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                DefaultTableModel m = (DefaultTableModel)table.getModel();
                if (row < m.getRowCount()) {
                    String type = (String)m.getValueAt(row, 2);
                    if ("Directory".equals(type) || "DIR".equals(type) || type.startsWith("DIR (")) {
                        label.setIcon(SFTP.this.folderIcon);
                    } else {
                        label.setIcon(SFTP.this.fileIcon);
                    }
                }
                if (!isSelected) {
                    label.setBackground(row % 2 == 0 ? TABLE_BG_COLOR : TABLE_ALT_BG_COLOR);
                }
                return label;
            }
        });
        table.getColumnModel().getColumn(0).setPreferredWidth(300);
        table.getColumnModel().getColumn(1).setPreferredWidth(100);
        table.getColumnModel().getColumn(2).setPreferredWidth(80);
        table.getColumnModel().getColumn(3).setPreferredWidth(150);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && (row = table.getSelectedRow()) >= 0) {
                    String name = ((FileEntry)model.getValueAt(row, 0)).getName();
                    String type = (String)model.getValueAt(row, 2);
                    if ("Directory".equals(type) || "DIR".equals(type) || type.startsWith("DIR (") || "Link".equals(type)) {
                        if (isLocal) {
                            SFTP.this.navigateLocalTo(name);
                        } else {
                            SFTP.this.navigateRemoteTo(name);
                        }
                    }
                }
            }
        });
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    int row = table.getSelectedRow();
                    if (row >= 0) {
                        String name = ((FileEntry)model.getValueAt(row, 0)).getName();
                        String type = (String)model.getValueAt(row, 2);
                        if ("Directory".equals(type) || "DIR".equals(type) || type.startsWith("DIR (") || "Link".equals(type)) {
                            if (isLocal) {
                                SFTP.this.navigateLocalTo(name);
                            } else {
                                SFTP.this.navigateRemoteTo(name);
                            }
                        }
                    }
                    e.consume();
                }
            }
        });
        JPopupMenu popupMenu = this.createContextMenu(isLocal, table);
        table.setComponentPopupMenu(popupMenu);
        table.setDropMode(DropMode.ON);
        if (isLocal) {
            this.localTableModel = model;
            this.localFileTable = table;
            this.setupDragSource(table, true);
        } else {
            this.remoteTableModel = model;
            this.remoteFileTable = table;
            this.setupDragSource(table, false);
        }
        this.setupDropTarget(table, isLocal);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setBackground(BACKGROUND_COLOR);
        scrollPane.getViewport().setBackground(TABLE_BG_COLOR);
        panel.add((Component)scrollPane, "Center");
        JPanel actionPanel = new JPanel(new FlowLayout(1, 10, 5));
        actionPanel.setBackground(PANEL_BG_COLOR);
        if (isLocal) {
            JButton uploadButton = new JButton("Upload \u2192");
            uploadButton.setBackground(new Color(40, 167, 69));
            uploadButton.setForeground(Color.WHITE);
            uploadButton.setFocusPainted(false);
            uploadButton.addActionListener(e -> this.uploadSelectedFiles());
            actionPanel.add(uploadButton);
            deleteButton = new JButton("Delete");
            deleteButton.addActionListener(e -> this.deleteSelectedFiles(true));
            actionPanel.add(deleteButton);
        } else {
            JButton downloadButton = new JButton("\u2190 Download");
            downloadButton.setBackground(new Color(0, 123, 255));
            downloadButton.setForeground(Color.WHITE);
            downloadButton.setFocusPainted(false);
            downloadButton.addActionListener(e -> this.downloadSelectedFiles());
            actionPanel.add(downloadButton);
            deleteButton = new JButton("Delete");
            deleteButton.addActionListener(e -> this.deleteSelectedFiles(false));
            actionPanel.add(deleteButton);
        }
        JButton newFolderButton = new JButton("New Folder");
        newFolderButton.addActionListener(e -> this.createNewFolder(isLocal));
        actionPanel.add(newFolderButton);
        JButton renameButton = new JButton("Rename");
        renameButton.addActionListener(e -> this.renameSelected(isLocal));
        actionPanel.add(renameButton);
        panel.add((Component)actionPanel, "South");
        return panel;
    }

    private JPanel createBottomPanel() {
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setBackground(PANEL_BG_COLOR);
        JPanel logPanel = new JPanel(new BorderLayout());
        logPanel.setBorder(BorderFactory.createTitledBorder("Activity Log"));
        logPanel.setBackground(PANEL_BG_COLOR);
        this.logArea = new JTextArea(6, 50);
        this.logArea.setEditable(false);
        this.logArea.setFont(new Font("Consolas", 0, 11));
        this.logArea.setBackground(isDarkMode ? new Color(30, 30, 30) : Color.WHITE);
        this.logArea.setForeground(isDarkMode ? new Color(200, 200, 200) : Color.BLACK);
        this.logArea.setCaretColor(isDarkMode ? Color.WHITE : Color.BLACK);
        JScrollPane logScroll = new JScrollPane(this.logArea);
        logScroll.setBackground(BACKGROUND_COLOR);
        logPanel.add((Component)logScroll, "Center");
        JButton clearLogButton = new JButton("Clear Log");
        clearLogButton.addActionListener(e -> this.logArea.setText(""));
        JPanel logButtonPanel = new JPanel(new FlowLayout(2));
        logButtonPanel.setBackground(PANEL_BG_COLOR);
        logButtonPanel.add(clearLogButton);
        logPanel.add((Component)logButtonPanel, "South");
        bottomPanel.add((Component)logPanel, "Center");
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setBorder(BorderFactory.createEtchedBorder());
        statusPanel.setBackground(PANEL_BG_COLOR);
        this.statusLabel = new JLabel(" Ready");
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 10));
        this.statusLabel.setForeground(FOREGROUND_COLOR);
        statusPanel.add((Component)this.statusLabel, "West");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(300, 20));
        this.progressBar.setVisible(false);
        this.progressBar.setBackground(PANEL_BG_COLOR);
        this.progressBar.setForeground(SELECTION_BG_COLOR);
        statusPanel.add((Component)this.progressBar, "East");
        bottomPanel.add((Component)statusPanel, "South");
        return bottomPanel;
    }

    private JPopupMenu createContextMenu(boolean isLocal, JTable table) {
        JPopupMenu menu = new JPopupMenu();
        menu.setBackground(TABLE_BG_COLOR);
        menu.setForeground(FOREGROUND_COLOR);
        JMenuItem transferItem = new JMenuItem(isLocal ? "Upload" : "Download");
        transferItem.addActionListener(e -> {
            if (isLocal) {
                this.uploadSelectedFiles();
            } else {
                this.downloadSelectedFiles();
            }
        });
        menu.add(transferItem);
        menu.addSeparator();
        JMenuItem deleteItem = new JMenuItem("Delete");
        deleteItem.addActionListener(e -> this.deleteSelectedFiles(isLocal));
        menu.add(deleteItem);
        JMenuItem renameItem = new JMenuItem("Rename");
        renameItem.addActionListener(e -> this.renameSelected(isLocal));
        menu.add(renameItem);
        menu.addSeparator();
        JMenuItem newFolderItem = new JMenuItem("New Folder");
        newFolderItem.addActionListener(e -> this.createNewFolder(isLocal));
        menu.add(newFolderItem);
        JMenuItem propertiesItem = new JMenuItem("Properties");
        propertiesItem.addActionListener(e -> this.showProperties(isLocal, table));
        menu.add(propertiesItem);
        menu.addSeparator();
        JMenuItem refreshItem = new JMenuItem("Refresh");
        refreshItem.addActionListener(e -> {
            if (isLocal) {
                this.refreshLocalFiles();
            } else {
                this.refreshRemoteFiles();
            }
        });
        menu.add(refreshItem);
        return menu;
    }

    private void loadProfiles() {
        File file = new File(PROFILES_FILE);
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
                    this.savedProfiles = (List)ois.readObject();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log("Error loading profiles: " + e.getMessage());
                this.savedProfiles = new ArrayList<ConnectionProfile>();
            }
        }
    }

    private void saveProfiles() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(PROFILES_FILE));){
                oos.writeObject(this.savedProfiles);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log("Error saving profiles: " + e.getMessage());
        }
    }

    private void refreshProfileComboBox() {
        this.profileComboBox.removeAllItems();
        this.profileComboBox.addItem(new ConnectionProfile("-- Select Profile --", "", "", ""));
        for (ConnectionProfile profile : this.savedProfiles) {
            this.profileComboBox.addItem(profile);
        }
    }

    private void loadSelectedProfile() {
        ConnectionProfile profile = (ConnectionProfile)this.profileComboBox.getSelectedItem();
        if (profile != null && !profile.getName().equals("-- Select Profile --")) {
            this.hostField.setText(profile.getHost());
            this.portField.setText(profile.getPort());
            this.usernameField.setText(profile.getUsername());
            this.passwordField.setText("");
        }
    }

    private void saveCurrentProfile() {
        String name = JOptionPane.showInputDialog(this, (Object)"Enter profile name:");
        if (name == null || name.trim().isEmpty()) {
            return;
        }
        for (ConnectionProfile p : this.savedProfiles) {
            if (!p.getName().equals(name)) continue;
            int confirm = JOptionPane.showConfirmDialog(this, "Profile '" + name + "' already exists. Overwrite?", "Confirm Overwrite", 0);
            if (confirm != 0) {
                return;
            }
            this.savedProfiles.remove(p);
            break;
        }
        ConnectionProfile profile = new ConnectionProfile(name, this.hostField.getText().trim(), this.portField.getText().trim(), this.usernameField.getText().trim());
        this.savedProfiles.add(profile);
        this.saveProfiles();
        this.refreshProfileComboBox();
        this.profileComboBox.setSelectedItem(profile);
        this.log("Profile saved: " + name);
    }

    private void deleteSelectedProfile() {
        ConnectionProfile profile = (ConnectionProfile)this.profileComboBox.getSelectedItem();
        if (profile == null || profile.getName().equals("-- Select Profile --")) {
            return;
        }
        int confirm = JOptionPane.showConfirmDialog(this, "Delete profile '" + profile.getName() + "'?", "Confirm Delete", 0);
        if (confirm == 0) {
            this.savedProfiles.remove(profile);
            this.saveProfiles();
            this.refreshProfileComboBox();
            this.log("Profile deleted: " + profile.getName());
        }
    }

    private void performSearch() {
        FileEntry entry;
        String searchTerm = this.searchField.getText().trim().toLowerCase();
        if (searchTerm.isEmpty()) {
            this.clearSearch();
            return;
        }
        this.currentSearchResults.clear();
        this.currentSearchIndex = -1;
        int i = 0;
        while (i < this.localTableModel.getRowCount()) {
            entry = (FileEntry)this.localTableModel.getValueAt(i, 0);
            if (entry.getName().toLowerCase().contains(searchTerm)) {
                this.currentSearchResults.add(new SearchResult(true, i, entry.getName()));
            }
            ++i;
        }
        if (this.isConnected) {
            i = 0;
            while (i < this.remoteTableModel.getRowCount()) {
                entry = (FileEntry)this.remoteTableModel.getValueAt(i, 0);
                if (entry.getName().toLowerCase().contains(searchTerm)) {
                    this.currentSearchResults.add(new SearchResult(false, i, entry.getName()));
                }
                ++i;
            }
        }
        this.updateSearchStatus();
        if (!this.currentSearchResults.isEmpty()) {
            this.navigateSearchResult(1);
        } else {
            this.log("No matches found for: " + searchTerm);
        }
    }

    private void clearSearch() {
        this.searchField.setText("");
        this.currentSearchResults.clear();
        this.currentSearchIndex = -1;
        this.localFileTable.clearSelection();
        this.remoteFileTable.clearSelection();
        this.updateSearchStatus();
    }

    private void navigateSearchResult(int direction) {
        if (this.currentSearchResults.isEmpty()) {
            return;
        }
        this.currentSearchIndex += direction;
        if (this.currentSearchIndex >= this.currentSearchResults.size()) {
            this.currentSearchIndex = 0;
        } else if (this.currentSearchIndex < 0) {
            this.currentSearchIndex = this.currentSearchResults.size() - 1;
        }
        SearchResult result = this.currentSearchResults.get(this.currentSearchIndex);
        if (result.isLocal) {
            this.localFileTable.setRowSelectionInterval(result.row, result.row);
            this.localFileTable.scrollRectToVisible(this.localFileTable.getCellRect(result.row, 0, true));
            this.localFileTable.requestFocus();
        } else {
            this.remoteFileTable.setRowSelectionInterval(result.row, result.row);
            this.remoteFileTable.scrollRectToVisible(this.remoteFileTable.getCellRect(result.row, 0, true));
            this.remoteFileTable.requestFocus();
        }
        this.updateSearchStatus();
    }

    private void updateSearchStatus() {
        Component[] components = ((JPanel)this.getContentPane().getComponent(1)).getComponents();
        JPanel searchPanel = (JPanel)((JPanel)this.getContentPane().getComponent(1)).getComponent(0);
        Component[] componentArray = searchPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if ("searchStatus".equals(c.getName()) && c instanceof JLabel) {
                JLabel statusLabel = (JLabel)c;
                if (this.currentSearchResults.isEmpty()) {
                    statusLabel.setText("No matches");
                    break;
                }
                statusLabel.setText(String.valueOf(this.currentSearchIndex + 1) + " of " + this.currentSearchResults.size());
                break;
            }
            ++n2;
        }
    }

    private void toggleDarkMode() {
        isDarkMode = !isDarkMode;
        this.darkModeToggle.setText(isDarkMode ? "\u2600 Light" : "\ud83c\udf19 Dark");
        if (isDarkMode) {
            BACKGROUND_COLOR = new Color(45, 45, 48);
            FOREGROUND_COLOR = new Color(220, 220, 220);
            PANEL_BG_COLOR = new Color(37, 37, 38);
            TABLE_BG_COLOR = new Color(30, 30, 30);
            TABLE_ALT_BG_COLOR = new Color(40, 40, 40);
            SELECTION_BG_COLOR = new Color(0, 122, 204);
            CONNECTED_COLOR = new Color(50, 205, 50);
            DISCONNECTED_COLOR = new Color(220, 20, 60);
        } else {
            BACKGROUND_COLOR = Color.WHITE;
            FOREGROUND_COLOR = Color.BLACK;
            PANEL_BG_COLOR = new Color(240, 240, 240);
            TABLE_BG_COLOR = Color.WHITE;
            TABLE_ALT_BG_COLOR = new Color(245, 245, 245);
            SELECTION_BG_COLOR = new Color(0, 123, 255);
            CONNECTED_COLOR = new Color(34, 139, 34);
            DISCONNECTED_COLOR = new Color(178, 34, 34);
        }
        this.applyTheme();
        this.refreshLocalFiles();
        if (this.isConnected) {
            this.refreshRemoteFiles();
        }
    }

    private void applyTheme() {
        SwingUtilities.invokeLater(() -> {
            this.updateComponentTree(this);
            this.logArea.setBackground(isDarkMode ? new Color(30, 30, 30) : Color.WHITE);
            this.logArea.setForeground(isDarkMode ? new Color(200, 200, 200) : Color.BLACK);
            this.logArea.setCaretColor(isDarkMode ? Color.WHITE : Color.BLACK);
            this.connectionStatusLabel.setForeground(this.isConnected ? CONNECTED_COLOR : DISCONNECTED_COLOR);
            this.repaint();
            this.revalidate();
        });
    }

    private void updateComponentTree(Container container) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JPanel) {
                c.setBackground(PANEL_BG_COLOR);
                this.updateComponentTree((Container)c);
            } else if (c instanceof JTable) {
                JTable table = (JTable)c;
                table.setBackground(TABLE_BG_COLOR);
                table.setForeground(FOREGROUND_COLOR);
                table.setSelectionBackground(SELECTION_BG_COLOR);
                table.setGridColor(isDarkMode ? new Color(60, 60, 60) : new Color(230, 230, 230));
            } else if (c instanceof JTextField) {
                c.setBackground(TABLE_BG_COLOR);
                c.setForeground(FOREGROUND_COLOR);
            } else if (c instanceof JLabel) {
                c.setForeground(FOREGROUND_COLOR);
            } else if (c instanceof JScrollPane) {
                c.setBackground(BACKGROUND_COLOR);
                ((JScrollPane)c).getViewport().setBackground(TABLE_BG_COLOR);
                this.updateComponentTree(((JScrollPane)c).getViewport());
            } else if (c instanceof JTabbedPane) {
                c.setBackground(BACKGROUND_COLOR);
                c.setForeground(FOREGROUND_COLOR);
            } else if (c instanceof Container) {
                this.updateComponentTree((Container)c);
            }
            ++n2;
        }
    }

    private void setupKeyboardShortcuts() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(116, 0), "refresh");
        this.getRootPane().getActionMap().put("refresh", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SFTP.this.refreshLocalFiles();
                if (SFTP.this.isConnected) {
                    SFTP.this.refreshRemoteFiles();
                }
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(70, 128), "search");
        this.getRootPane().getActionMap().put("search", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SFTP.this.searchField.requestFocus();
                SFTP.this.searchField.selectAll();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(84, 128), "newtab");
        this.getRootPane().getActionMap().put("newtab", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SFTP.this.createNewTab();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(87, 128), "closetab");
        this.getRootPane().getActionMap().put("closetab", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int currentIndex = SFTP.this.connectionTabs.getSelectedIndex();
                if (currentIndex >= 0 && SFTP.this.connectionTabs.getTabCount() > 1) {
                    JPanel tabPanel = (JPanel)SFTP.this.connectionTabs.getComponentAt(currentIndex);
                    Iterator iterator = SFTP.this.tabConnections.entrySet().iterator();
                    if (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        SFTP.this.closeTab((Integer)entry.getKey());
                    }
                }
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getRootPane().getActionMap().put("delete", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SFTP.this.localFileTable.hasFocus()) {
                    SFTP.this.deleteSelectedFiles(true);
                } else if (SFTP.this.remoteFileTable.hasFocus()) {
                    SFTP.this.deleteSelectedFiles(false);
                }
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(113, 0), "rename");
        this.getRootPane().getActionMap().put("rename", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SFTP.this.localFileTable.hasFocus()) {
                    SFTP.this.renameSelected(true);
                } else if (SFTP.this.remoteFileTable.hasFocus()) {
                    SFTP.this.renameSelected(false);
                }
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(8, 0), "parent");
        this.getRootPane().getActionMap().put("parent", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SFTP.this.localFileTable.hasFocus()) {
                    SFTP.this.navigateLocalUp();
                } else if (SFTP.this.remoteFileTable.hasFocus()) {
                    SFTP.this.navigateRemoteUp();
                }
            }
        });
    }

    private void setupDragSource(final JTable table, final boolean isLocal) {
        DragSource ds = new DragSource();
        DragGestureRecognizer dgr = ds.createDefaultDragGestureRecognizer(table, 1, new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                int[] rows = table.getSelectedRows();
                if (rows.length == 0) {
                    return;
                }
                ArrayList<FileEntry> files = new ArrayList<FileEntry>();
                DefaultTableModel model = (DefaultTableModel)table.getModel();
                int[] nArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    int row = nArray[n2];
                    files.add((FileEntry)model.getValueAt(row, 0));
                    ++n2;
                }
                try {
                    FileTransferable transferable = new FileTransferable(files, isLocal, SFTP.this.currentLocalPath);
                    dge.startDrag(DragSource.DefaultCopyDrop, transferable, new DragSourceAdapter(){});
                }
                catch (InvalidDnDOperationException e) {
                    System.err.println("Drag already in progress, ignoring: " + e.getMessage());
                }
                catch (Exception e) {
                    SFTP.this.log("Error starting drag: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        });
    }

    private void setupDropTarget(JTable table, final boolean isLocal) {
        new DropTarget(table, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                try {
                    dtde.acceptDrop(1);
                    Transferable transferable = dtde.getTransferable();
                    if (transferable.isDataFlavorSupported(FileTransferable.INTERNAL_FLAVOR)) {
                        FileTransferable ft = (FileTransferable)transferable.getTransferData(FileTransferable.INTERNAL_FLAVOR);
                        if (ft.isLocal() && !isLocal && SFTP.this.isConnected) {
                            SFTP.this.log("Internal drag & drop: Uploading " + ft.getFiles().size() + " item(s)...");
                            final ArrayList<FileEntry> filesToUpload = new ArrayList<FileEntry>(ft.getFiles());
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    int success = 0;
                                    int failed = 0;
                                    for (FileEntry entry : filesToUpload) {
                                        try {
                                            File file = new File(SFTP.this.currentLocalPath, entry.getName());
                                            SFTP.this.uploadFile(file);
                                            ++success;
                                        }
                                        catch (Exception e) {
                                            ++failed;
                                        }
                                    }
                                    SFTP.this.log("Upload complete: " + success + " succeeded, " + failed + " failed");
                                    SwingUtilities.invokeLater(() -> {
                                        SFTP.this.refreshRemoteFiles();
                                        SFTP.this.showProgress(false);
                                    });
                                }
                            }).start();
                        } else if (!ft.isLocal() && isLocal && SFTP.this.isConnected) {
                            SFTP.this.log("Internal drag & drop: Downloading " + ft.getFiles().size() + " item(s)...");
                            final ArrayList<FileEntry> filesToDownload = new ArrayList<FileEntry>(ft.getFiles());
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    int success = 0;
                                    int failed = 0;
                                    for (FileEntry entry : filesToDownload) {
                                        try {
                                            SFTP.this.downloadFile(entry.getName(), entry.isDirectory());
                                            ++success;
                                        }
                                        catch (Exception e) {
                                            ++failed;
                                        }
                                    }
                                    SFTP.this.log("Download complete: " + success + " succeeded, " + failed + " failed");
                                    SwingUtilities.invokeLater(() -> {
                                        SFTP.this.refreshLocalFiles();
                                        SFTP.this.showProgress(false);
                                    });
                                }
                            }).start();
                        }
                        dtde.dropComplete(true);
                        return;
                    }
                    if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        if (!isLocal && SFTP.this.isConnected) {
                            SFTP.this.log("External drag & drop: Uploading " + files.size() + " item(s)...");
                            final ArrayList filesToUpload = new ArrayList(files);
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    int success = 0;
                                    int failed = 0;
                                    for (File file : filesToUpload) {
                                        try {
                                            SFTP.this.uploadFile(file);
                                            ++success;
                                        }
                                        catch (Exception e) {
                                            ++failed;
                                        }
                                    }
                                    SFTP.this.log("Upload complete: " + success + " succeeded, " + failed + " failed");
                                    SwingUtilities.invokeLater(() -> {
                                        SFTP.this.refreshRemoteFiles();
                                        SFTP.this.showProgress(false);
                                    });
                                }
                            }).start();
                        } else if (isLocal) {
                            SFTP.this.log("External drag & drop: " + files.size() + " item(s) dropped on local panel");
                        }
                    }
                    dtde.dropComplete(true);
                }
                catch (Exception e) {
                    SFTP.this.log("Drag & drop error: " + e.getMessage());
                    dtde.dropComplete(false);
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                if (!isLocal && !SFTP.this.isConnected) {
                    dtde.rejectDrag();
                } else {
                    dtde.acceptDrag(1);
                }
            }

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                dtde.acceptDrag(1);
            }
        });
    }

    private void connect() {
        String host = this.hostField.getText().trim();
        String port = this.portField.getText().trim();
        String username = this.usernameField.getText().trim();
        String password = new String(this.passwordField.getPassword());
        if (host.isEmpty() || username.isEmpty()) {
            this.showError("Host and username are required");
            return;
        }
        new Thread(() -> {
            try {
                this.log("Connecting to " + host + ":" + port + "...");
                this.setStatus("Connecting...");
                JSch jsch = new JSch();
                this.session = jsch.getSession(username, host, Integer.parseInt(port));
                this.session.setPassword(password);
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", "no");
                this.session.setConfig(config);
                this.session.setTimeout(30000);
                this.session.connect();
                Channel channel = this.session.openChannel("sftp");
                channel.connect();
                this.sftpChannel = (ChannelSftp)channel;
                this.currentRemotePath = this.sftpChannel.pwd();
                this.isConnected = true;
                int currentTab = this.connectionTabs.getSelectedIndex();
                ConnectionData connData = this.tabConnections.get(currentTab);
                if (connData != null) {
                    connData.isConnected = true;
                    connData.remotePath = this.currentRemotePath;
                }
                SwingUtilities.invokeLater(() -> {
                    this.connectButton.setEnabled(false);
                    this.disconnectButton.setEnabled(true);
                    this.hostField.setEnabled(false);
                    this.portField.setEnabled(false);
                    this.usernameField.setEnabled(false);
                    this.passwordField.setEnabled(false);
                    this.connectionStatusLabel.setText("\u25cf Connected to " + host);
                    this.connectionStatusLabel.setForeground(CONNECTED_COLOR);
                    int tabIndex = this.connectionTabs.getSelectedIndex();
                    this.connectionTabs.setTitleAt(tabIndex, host);
                    this.remotePathField.setText(this.currentRemotePath);
                    this.log("Connected successfully to " + host);
                    this.setStatus("Connected");
                    this.refreshRemoteFiles();
                });
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(() -> {
                    this.log("Connection failed: " + e.getMessage());
                    this.setStatus("Connection failed");
                    this.showError("Connection failed: " + e.getMessage());
                });
            }
        }).start();
    }

    private void disconnect() {
        this.disconnectTab(this.getCurrentTabId());
    }

    private void disconnectTab(int tabId) {
        if (this.sftpChannel != null && this.sftpChannel.isConnected()) {
            this.sftpChannel.disconnect();
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
        this.isConnected = false;
        ConnectionData connData = this.tabConnections.get(tabId);
        if (connData != null) {
            connData.isConnected = false;
        }
        this.connectButton.setEnabled(true);
        this.disconnectButton.setEnabled(false);
        this.hostField.setEnabled(true);
        this.portField.setEnabled(true);
        this.usernameField.setEnabled(true);
        this.passwordField.setEnabled(true);
        this.connectionStatusLabel.setText("\u25cf Not Connected");
        this.connectionStatusLabel.setForeground(DISCONNECTED_COLOR);
        this.remoteTableModel.setRowCount(0);
        this.remotePathField.setText("");
        this.log("Disconnected");
        this.setStatus("Disconnected");
    }

    private int getCurrentTabId() {
        return this.connectionTabs.getSelectedIndex();
    }

    private void refreshLocalFiles() {
        this.localTableModel.setRowCount(0);
        File dir = new File(this.currentLocalPath);
        File[] files = dir.listFiles();
        if (files != null) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    if (f1.isDirectory() && !f2.isDirectory()) {
                        return -1;
                    }
                    if (!f1.isDirectory() && f2.isDirectory()) {
                        return 1;
                    }
                    return f1.getName().compareToIgnoreCase(f2.getName());
                }
            });
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            int count = 0;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileEntry entry = new FileEntry(file.getName(), file.isDirectory());
                String size = file.isDirectory() ? "" : this.formatFileSize(file.length());
                String type = file.isDirectory() ? "DIR" : this.getFileType(file.getName());
                String modified = sdf.format(new Date(file.lastModified()));
                this.localTableModel.addRow(new Object[]{entry, size, type, modified});
                ++count;
                ++n2;
            }
            this.localPathField.setText(this.currentLocalPath);
            this.log("Refreshed local: " + this.currentLocalPath + " (" + count + " items)");
        } else {
            this.log("Cannot read directory: " + this.currentLocalPath);
        }
    }

    private void refreshRemoteFiles() {
        if (!this.isConnected) {
            return;
        }
        new Thread(() -> {
            try {
                SwingUtilities.invokeLater(() -> this.remoteTableModel.setRowCount(0));
                Vector files = this.sftpChannel.ls(this.currentRemotePath);
                ArrayList<ChannelSftp.LsEntry> sortedFiles = new ArrayList<ChannelSftp.LsEntry>(files);
                sortedFiles.removeIf(entry -> ".".equals(entry.getFilename()) || "..".equals(entry.getFilename()));
                Collections.sort(sortedFiles, new Comparator<ChannelSftp.LsEntry>(){

                    @Override
                    public int compare(ChannelSftp.LsEntry e1, ChannelSftp.LsEntry e2) {
                        boolean d2;
                        boolean d1 = e1.getAttrs().isDir() || e1.getAttrs().isLink();
                        boolean bl = d2 = e2.getAttrs().isDir() || e2.getAttrs().isLink();
                        if (d1 && !d2) {
                            return -1;
                        }
                        if (!d1 && d2) {
                            return 1;
                        }
                        return e1.getFilename().compareToIgnoreCase(e2.getFilename());
                    }
                });
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (ChannelSftp.LsEntry entry2 : sortedFiles) {
                    String size;
                    String name = entry2.getFilename();
                    SftpATTRS attrs = entry2.getAttrs();
                    boolean isDir = attrs.isDir();
                    boolean isLink = attrs.isLink();
                    if (isLink && !isDir) {
                        try {
                            String fullPath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + name : String.valueOf(this.currentRemotePath) + "/" + name;
                            SftpATTRS linkAttrs = this.sftpChannel.stat(fullPath);
                            isDir = linkAttrs.isDir();
                        }
                        catch (Exception fullPath) {
                            // empty catch block
                        }
                    }
                    FileEntry fileEntry = new FileEntry(name, isDir);
                    String string = size = isDir ? "" : this.formatFileSize(attrs.getSize());
                    String type = isLink && isDir ? "DIR (Link)" : (isLink ? "Link" : (isDir ? "DIR" : this.getFileType(name)));
                    String modified = sdf.format(new Date((long)attrs.getMTime() * 1000L));
                    SwingUtilities.invokeLater(() -> this.remoteTableModel.addRow(new Object[]{fileEntry, size, type, modified}));
                }
                SwingUtilities.invokeLater(() -> this.remotePathField.setText(this.currentRemotePath));
                this.log("Refreshed remote: " + this.currentRemotePath + " (" + sortedFiles.size() + " items)");
            }
            catch (Exception e) {
                this.log("Error refreshing remote: " + e.getMessage());
                SwingUtilities.invokeLater(() -> this.showError("Error refreshing: " + e.getMessage()));
            }
        }).start();
    }

    private void navigateLocalTo(String name) {
        File newDir = new File(this.currentLocalPath, name);
        if (newDir.exists() && newDir.isDirectory()) {
            try {
                this.currentLocalPath = newDir.getCanonicalPath();
                this.refreshLocalFiles();
            }
            catch (IOException e) {
                this.log("Navigation error: " + e.getMessage());
            }
        }
    }

    private void navigateLocalUp() {
        File current = new File(this.currentLocalPath);
        File parent = current.getParentFile();
        if (parent != null) {
            this.currentLocalPath = parent.getAbsolutePath();
            this.refreshLocalFiles();
        }
    }

    private void navigateLocalHome() {
        this.currentLocalPath = System.getProperty("user.home");
        this.refreshLocalFiles();
    }

    private void browseLocalFolder() {
        JFileChooser fileChooser = new JFileChooser(this.currentLocalPath);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle("Select Folder");
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            File selectedFolder = fileChooser.getSelectedFile();
            this.currentLocalPath = selectedFolder.getAbsolutePath();
            this.refreshLocalFiles();
            this.log("Browsed to: " + this.currentLocalPath);
        }
    }

    private void navigateRemoteTo(String name) {
        if (!this.isConnected) {
            return;
        }
        new Thread(() -> {
            try {
                String newPath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + name : String.valueOf(this.currentRemotePath) + "/" + name;
                try {
                    this.sftpChannel.cd(newPath);
                    this.currentRemotePath = this.sftpChannel.pwd();
                    SwingUtilities.invokeLater(this::refreshRemoteFiles);
                    this.log("Navigated to: " + this.currentRemotePath);
                }
                catch (SftpException e) {
                    this.log("Cannot navigate to: " + name + " - " + e.getMessage());
                    SwingUtilities.invokeLater(() -> this.showError("Cannot open: " + name + "\n" + e.getMessage()));
                }
            }
            catch (Exception e) {
                this.log("Navigation error: " + e.getMessage());
                SwingUtilities.invokeLater(() -> this.showError("Navigation error: " + e.getMessage()));
            }
        }).start();
    }

    private void navigateRemoteUp() {
        if (!this.isConnected) {
            return;
        }
        new Thread(() -> {
            try {
                this.sftpChannel.cd("..");
                this.currentRemotePath = this.sftpChannel.pwd();
                SwingUtilities.invokeLater(this::refreshRemoteFiles);
            }
            catch (Exception e) {
                this.log("Navigation error: " + e.getMessage());
            }
        }).start();
    }

    private void navigateRemoteHome() {
        if (!this.isConnected) {
            return;
        }
        new Thread(() -> {
            try {
                this.sftpChannel.cd(this.sftpChannel.getHome());
                this.currentRemotePath = this.sftpChannel.pwd();
                SwingUtilities.invokeLater(this::refreshRemoteFiles);
            }
            catch (Exception e) {
                this.log("Navigation error: " + e.getMessage());
            }
        }).start();
    }

    private void uploadSelectedFiles() {
        if (!this.isConnected) {
            this.showError("Not connected to server");
            return;
        }
        int[] rows = this.localFileTable.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        final ArrayList<File> filesToUpload = new ArrayList<File>();
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            FileEntry entry = (FileEntry)this.localTableModel.getValueAt(row, 0);
            File file = new File(this.currentLocalPath, entry.getName());
            filesToUpload.add(file);
            ++n2;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                SFTP.this.log("Starting upload of " + filesToUpload.size() + " item(s)...");
                int success = 0;
                int failed = 0;
                for (File file : filesToUpload) {
                    try {
                        SFTP.this.uploadFile(file);
                        ++success;
                    }
                    catch (Exception e) {
                        SFTP.this.log("\u2717 Upload error: " + file.getName() + " - " + e.getMessage());
                        ++failed;
                    }
                }
                SFTP.this.log("Upload complete: " + success + " succeeded, " + failed + " failed");
                SwingUtilities.invokeLater(() -> {
                    SFTP.this.refreshRemoteFiles();
                    SFTP.this.showProgress(false);
                });
            }
        }).start();
    }

    private void uploadFile(File file) {
        try {
            if (file.isDirectory()) {
                this.uploadDirectory(file, this.currentRemotePath);
            } else {
                this.log("Uploading: " + file.getName() + " (" + this.formatFileSize(file.length()) + ")");
                this.showProgress(true);
                String remotePath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + file.getName() : String.valueOf(this.currentRemotePath) + "/" + file.getName();
                FileProgressMonitor monitor = new FileProgressMonitor(file.length(), file.getName());
                this.sftpChannel.put(file.getAbsolutePath(), remotePath, (SftpProgressMonitor)monitor, 0);
                this.log("\u2713 Upload complete: " + file.getName());
                this.showProgress(false);
            }
        }
        catch (Exception e) {
            this.log("\u2717 Upload failed: " + file.getName() + " - " + e.getMessage());
            this.showProgress(false);
            throw new RuntimeException(e);
        }
    }

    private void uploadDirectory(File dir, String remoteBasePath) {
        try {
            String remoteDirPath;
            block10: {
                remoteDirPath = remoteBasePath.endsWith("/") ? String.valueOf(remoteBasePath) + dir.getName() : String.valueOf(remoteBasePath) + "/" + dir.getName();
                try {
                    this.sftpChannel.mkdir(remoteDirPath);
                    this.log("\u2713 Created remote directory: " + dir.getName());
                }
                catch (SftpException e) {
                    if (e.id == 4) break block10;
                    this.log("Directory already exists: " + dir.getName());
                }
            }
            File[] files = dir.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        this.uploadDirectory(file, remoteDirPath);
                    } else {
                        try {
                            this.log("Uploading: " + file.getName() + " (" + this.formatFileSize(file.length()) + ")");
                            this.showProgress(true);
                            String remoteFilePath = remoteDirPath.endsWith("/") ? String.valueOf(remoteDirPath) + file.getName() : String.valueOf(remoteDirPath) + "/" + file.getName();
                            FileProgressMonitor monitor = new FileProgressMonitor(file.length(), file.getName());
                            this.sftpChannel.put(file.getAbsolutePath(), remoteFilePath, (SftpProgressMonitor)monitor, 0);
                            this.log("\u2713 Uploaded: " + file.getName());
                            this.showProgress(false);
                        }
                        catch (Exception e) {
                            this.log("\u2717 Failed to upload: " + file.getName() + " - " + e.getMessage());
                            this.showProgress(false);
                        }
                    }
                    ++n2;
                }
            }
            this.log("\u2713 Folder upload complete: " + dir.getName());
        }
        catch (Exception e) {
            this.log("\u2717 Error uploading directory: " + dir.getName() + " - " + e.getMessage());
            this.showProgress(false);
        }
    }

    private void downloadSelectedFiles() {
        if (!this.isConnected) {
            this.showError("Not connected to server");
            return;
        }
        int[] rows = this.remoteFileTable.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        final ArrayList<FileDownloadInfo> filesToDownload = new ArrayList<FileDownloadInfo>();
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            FileEntry entry = (FileEntry)this.remoteTableModel.getValueAt(row, 0);
            filesToDownload.add(new FileDownloadInfo(entry.getName(), entry.isDirectory()));
            ++n2;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                SFTP.this.log("Starting download of " + filesToDownload.size() + " item(s)...");
                int success = 0;
                int failed = 0;
                for (FileDownloadInfo info : filesToDownload) {
                    try {
                        SFTP.this.downloadFile(info.name, info.isDirectory);
                        ++success;
                    }
                    catch (Exception e) {
                        SFTP.this.log("\u2717 Download error: " + info.name + " - " + e.getMessage());
                        ++failed;
                    }
                }
                SFTP.this.log("Download complete: " + success + " succeeded, " + failed + " failed");
                SwingUtilities.invokeLater(() -> {
                    SFTP.this.refreshLocalFiles();
                    SFTP.this.showProgress(false);
                });
            }
        }).start();
    }

    private void downloadFile(String filename, boolean isDirectory) {
        try {
            String remotePath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + filename : String.valueOf(this.currentRemotePath) + "/" + filename;
            String localPath = String.valueOf(this.currentLocalPath) + File.separator + filename;
            if (isDirectory) {
                this.downloadDirectory(remotePath, localPath);
            } else {
                SftpATTRS attrs = this.sftpChannel.stat(remotePath);
                this.log("Downloading: " + filename + " (" + this.formatFileSize(attrs.getSize()) + ")");
                this.showProgress(true);
                FileProgressMonitor monitor = new FileProgressMonitor(attrs.getSize(), filename);
                this.sftpChannel.get(remotePath, localPath, monitor, 0);
                this.log("\u2713 Download complete: " + filename);
                this.showProgress(false);
            }
        }
        catch (Exception e) {
            this.log("\u2717 Download failed: " + filename + " - " + e.getMessage());
            this.showProgress(false);
            throw new RuntimeException(e);
        }
    }

    private void downloadDirectory(String remotePath, String localPath) {
        try {
            File localDir = new File(localPath);
            if (!localDir.exists()) {
                if (localDir.mkdirs()) {
                    this.log("\u2713 Created local directory: " + localDir.getName());
                } else {
                    this.log("\u2717 Failed to create local directory: " + localDir.getName());
                    return;
                }
            }
            Vector files = this.sftpChannel.ls(remotePath);
            for (ChannelSftp.LsEntry entry : files) {
                String name = entry.getFilename();
                if (".".equals(name) || "..".equals(name)) continue;
                String newRemotePath = String.valueOf(remotePath) + "/" + name;
                String newLocalPath = String.valueOf(localPath) + File.separator + name;
                if (entry.getAttrs().isDir()) {
                    this.downloadDirectory(newRemotePath, newLocalPath);
                    continue;
                }
                try {
                    SftpATTRS attrs = entry.getAttrs();
                    this.log("Downloading: " + name + " (" + this.formatFileSize(attrs.getSize()) + ")");
                    this.showProgress(true);
                    FileProgressMonitor monitor = new FileProgressMonitor(attrs.getSize(), name);
                    this.sftpChannel.get(newRemotePath, newLocalPath, monitor, 0);
                    this.log("\u2713 Downloaded: " + name);
                    this.showProgress(false);
                }
                catch (Exception e) {
                    this.log("\u2717 Failed to download: " + name + " - " + e.getMessage());
                    this.showProgress(false);
                }
            }
            this.log("\u2713 Folder download complete: " + new File(localPath).getName());
        }
        catch (Exception e) {
            this.log("\u2717 Error downloading directory: " + e.getMessage());
            this.showProgress(false);
        }
    }

    private void deleteSelectedFiles(boolean isLocal) {
        JTable table = isLocal ? this.localFileTable : this.remoteFileTable;
        int[] rows = table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        int confirm = JOptionPane.showConfirmDialog(this, "Delete " + rows.length + " item(s)?", "Confirm Delete", 0, 2);
        if (confirm != 0) {
            return;
        }
        new Thread(() -> {
            DefaultTableModel model = isLocal ? this.localTableModel : this.remoteTableModel;
            int[] nArray2 = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray2[n2];
                FileEntry entry = (FileEntry)model.getValueAt(row, 0);
                try {
                    if (isLocal) {
                        File file = new File(this.currentLocalPath, entry.getName());
                        this.deleteLocalFile(file);
                        this.log("\u2713 Deleted local: " + entry.getName());
                    } else if (this.isConnected) {
                        String remotePath;
                        String string = remotePath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + entry.getName() : String.valueOf(this.currentRemotePath) + "/" + entry.getName();
                        if (entry.isDirectory()) {
                            this.deleteRemoteDirectory(remotePath);
                        } else {
                            this.sftpChannel.rm(remotePath);
                        }
                        this.log("\u2713 Deleted remote: " + entry.getName());
                    }
                }
                catch (Exception e) {
                    this.log("\u2717 Delete failed: " + entry.getName() + " - " + e.getMessage());
                }
                ++n2;
            }
            SwingUtilities.invokeLater(() -> {
                if (isLocal) {
                    this.refreshLocalFiles();
                } else {
                    this.refreshRemoteFiles();
                }
            });
        }).start();
    }

    private void deleteLocalFile(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.deleteLocalFile(f);
                ++n2;
            }
        }
        file.delete();
    }

    private void deleteRemoteDirectory(String path) throws SftpException {
        Vector files = this.sftpChannel.ls(path);
        for (ChannelSftp.LsEntry entry : files) {
            String name = entry.getFilename();
            if (".".equals(name) || "..".equals(name)) continue;
            String filePath = String.valueOf(path) + "/" + name;
            if (entry.getAttrs().isDir()) {
                this.deleteRemoteDirectory(filePath);
                continue;
            }
            this.sftpChannel.rm(filePath);
        }
        this.sftpChannel.rmdir(path);
    }

    private void renameSelected(boolean isLocal) {
        JTable table = isLocal ? this.localFileTable : this.remoteFileTable;
        int row = table.getSelectedRow();
        if (row < 0) {
            return;
        }
        DefaultTableModel model = isLocal ? this.localTableModel : this.remoteTableModel;
        FileEntry entry = (FileEntry)model.getValueAt(row, 0);
        String oldName = entry.getName();
        String newName = JOptionPane.showInputDialog(this, "New name:", oldName);
        if (newName == null || newName.trim().isEmpty() || newName.equals(oldName)) {
            return;
        }
        new Thread(() -> {
            try {
                if (isLocal) {
                    File oldFile = new File(this.currentLocalPath, oldName);
                    File newFile = new File(this.currentLocalPath, newName);
                    if (oldFile.renameTo(newFile)) {
                        this.log("\u2713 Renamed local: " + oldName + " \u2192 " + newName);
                        SwingUtilities.invokeLater(this::refreshLocalFiles);
                    }
                } else {
                    if (!this.isConnected) {
                        return;
                    }
                    String oldPath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + oldName : String.valueOf(this.currentRemotePath) + "/" + oldName;
                    String newPath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + newName : String.valueOf(this.currentRemotePath) + "/" + newName;
                    this.sftpChannel.rename(oldPath, newPath);
                    this.log("\u2713 Renamed remote: " + oldName + " \u2192 " + newName);
                    SwingUtilities.invokeLater(this::refreshRemoteFiles);
                }
            }
            catch (Exception e) {
                this.log("\u2717 Rename failed: " + e.getMessage());
                SwingUtilities.invokeLater(() -> this.showError("Rename failed: " + e.getMessage()));
            }
        }).start();
    }

    private void createNewFolder(boolean isLocal) {
        String folderName = JOptionPane.showInputDialog(this, (Object)"Enter folder name:");
        if (folderName == null || folderName.trim().isEmpty()) {
            return;
        }
        new Thread(() -> {
            try {
                if (isLocal) {
                    File newFolder = new File(this.currentLocalPath, folderName);
                    if (newFolder.mkdir()) {
                        this.log("\u2713 Created local folder: " + folderName);
                        SwingUtilities.invokeLater(this::refreshLocalFiles);
                    }
                } else {
                    if (!this.isConnected) {
                        return;
                    }
                    String remotePath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + folderName : String.valueOf(this.currentRemotePath) + "/" + folderName;
                    this.sftpChannel.mkdir(remotePath);
                    this.log("\u2713 Created remote folder: " + folderName);
                    SwingUtilities.invokeLater(this::refreshRemoteFiles);
                }
            }
            catch (Exception e) {
                this.log("\u2717 Create folder failed: " + e.getMessage());
                SwingUtilities.invokeLater(() -> this.showError("Create folder failed: " + e.getMessage()));
            }
        }).start();
    }

    private void showProperties(boolean isLocal, JTable table) {
        int row = table.getSelectedRow();
        if (row < 0) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        FileEntry entry = (FileEntry)model.getValueAt(row, 0);
        String size = (String)model.getValueAt(row, 1);
        String type = (String)model.getValueAt(row, 2);
        String modified = (String)model.getValueAt(row, 3);
        StringBuilder props = new StringBuilder();
        props.append("Name: ").append(entry.getName()).append("\n");
        props.append("Type: ").append(type).append("\n");
        props.append("Size: ").append(size.isEmpty() ? "N/A" : size).append("\n");
        props.append("Modified: ").append(modified).append("\n");
        if (isLocal) {
            File file = new File(this.currentLocalPath, entry.getName());
            props.append("Path: ").append(file.getAbsolutePath()).append("\n");
            props.append("Readable: ").append(file.canRead()).append("\n");
            props.append("Writable: ").append(file.canWrite()).append("\n");
        } else {
            String remotePath = this.currentRemotePath.endsWith("/") ? String.valueOf(this.currentRemotePath) + entry.getName() : String.valueOf(this.currentRemotePath) + "/" + entry.getName();
            props.append("Path: ").append(remotePath).append("\n");
        }
        JTextArea textArea = new JTextArea(props.toString());
        textArea.setEditable(false);
        textArea.setFont(new Font("Monospaced", 0, 12));
        textArea.setBackground(TABLE_BG_COLOR);
        textArea.setForeground(FOREGROUND_COLOR);
        JOptionPane.showMessageDialog(this, new JScrollPane(textArea), "Properties - " + entry.getName(), 1);
    }

    private String formatFileSize(long size) {
        if (size < 1024L) {
            return String.valueOf(size) + " B";
        }
        if (size < 0x100000L) {
            return String.format("%.2f KB", (double)size / 1024.0);
        }
        if (size < 0x40000000L) {
            return String.format("%.2f MB", (double)size / 1048576.0);
        }
        return String.format("%.2f GB", (double)size / 1.073741824E9);
    }

    private String getFileType(String filename) {
        int lastDot = filename.lastIndexOf(46);
        if (lastDot > 0 && lastDot < filename.length() - 1) {
            return filename.substring(lastDot + 1).toUpperCase();
        }
        return "File";
    }

    private void log(String message) {
        SwingUtilities.invokeLater(() -> {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            this.logArea.append("[" + sdf.format(new Date()) + "] " + message + "\n");
            this.logArea.setCaretPosition(this.logArea.getDocument().getLength());
        });
    }

    private void setStatus(String status) {
        SwingUtilities.invokeLater(() -> this.statusLabel.setText(" " + status));
    }

    private void showProgress(boolean show) {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setVisible(show);
            if (!show) {
                this.progressBar.setValue(0);
                this.progressBar.setString("");
            }
        });
    }

    private void showError(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(() -> {
            SFTP client = new SFTP();
            client.setVisible(true);
        });
    }

    class ConnectionData {
        int tabId;
        boolean isConnected = false;
        String localPath;
        String remotePath;
        Session session;
        ChannelSftp sftpChannel;

        ConnectionData() {
        }
    }

    static class ConnectionProfile
    implements Serializable {
        private String name;
        private String host;
        private String port;
        private String username;

        public ConnectionProfile(String name, String host, String port, String username) {
            this.name = name;
            this.host = host;
            this.port = port;
            this.username = username;
        }

        public String getName() {
            return this.name;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String getUsername() {
            return this.username;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class FileDownloadInfo {
        String name;
        boolean isDirectory;

        FileDownloadInfo(String name, boolean isDirectory) {
            this.name = name;
            this.isDirectory = isDirectory;
        }
    }

    class FileEntry {
        private String name;
        private boolean isDirectory;

        public FileEntry(String name, boolean isDirectory) {
            this.name = name;
            this.isDirectory = isDirectory;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public String toString() {
            return this.name;
        }
    }

    class FileProgressMonitor
    implements SftpProgressMonitor {
        private long max;
        private long count;
        private String filename;
        private long lastUpdate;

        public FileProgressMonitor(long max, String filename) {
            this.max = max;
            this.filename = filename;
            this.count = 0L;
            this.lastUpdate = System.currentTimeMillis();
        }

        @Override
        public void init(int op, String src, String dest, long max) {
            this.max = max;
            this.count = 0L;
        }

        @Override
        public boolean count(long count) {
            this.count += count;
            long now = System.currentTimeMillis();
            if (now - this.lastUpdate > 100L) {
                int percent = this.max > 0L ? (int)(this.count * 100L / this.max) : 0;
                String progress = String.format("%s - %d%% (%s / %s)", this.filename, percent, SFTP.this.formatFileSize(this.count), SFTP.this.formatFileSize(this.max));
                SwingUtilities.invokeLater(() -> {
                    SFTP.this.progressBar.setValue(percent);
                    SFTP.this.progressBar.setString(progress);
                });
                this.lastUpdate = now;
            }
            return true;
        }

        @Override
        public void end() {
            SwingUtilities.invokeLater(() -> {
                SFTP.this.progressBar.setValue(100);
                SFTP.this.progressBar.setString(String.valueOf(this.filename) + " - Complete");
            });
        }
    }

    static class FileTransferable
    implements Transferable {
        private List<FileEntry> files;
        private boolean isLocal;
        private String currentLocalPath;
        public static final DataFlavor INTERNAL_FLAVOR;

        static {
            DataFlavor flavor = null;
            try {
                flavor = new DataFlavor(FileTransferable.class, "InternalFileTransfer");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            INTERNAL_FLAVOR = flavor;
        }

        public FileTransferable(List<FileEntry> files, boolean isLocal, String currentLocalPath) {
            this.files = files;
            this.isLocal = isLocal;
            this.currentLocalPath = currentLocalPath;
        }

        public List<FileEntry> getFiles() {
            return this.files;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (this.isLocal) {
                ArrayList<File> fileList = new ArrayList<File>();
                for (FileEntry entry : this.files) {
                    fileList.add(new File(this.currentLocalPath, entry.getName()));
                }
                return new DataFlavor[]{INTERNAL_FLAVOR, DataFlavor.javaFileListFlavor};
            }
            return new DataFlavor[]{INTERNAL_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (INTERNAL_FLAVOR.equals(flavor)) {
                return true;
            }
            return this.isLocal && DataFlavor.javaFileListFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (INTERNAL_FLAVOR.equals(flavor)) {
                return this;
            }
            if (this.isLocal && DataFlavor.javaFileListFlavor.equals(flavor)) {
                ArrayList<File> fileList = new ArrayList<File>();
                for (FileEntry entry : this.files) {
                    fileList.add(new File(this.currentLocalPath, entry.getName()));
                }
                return fileList;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    class SearchResult {
        boolean isLocal;
        int row;
        String filename;

        SearchResult(boolean isLocal, int row, String filename) {
            this.isLocal = isLocal;
            this.row = row;
            this.filename = filename;
        }
    }
}

